package com.ovopark.boot.kit.http;

import org.apache.commons.io.IOUtils;
import org.apache.http.HeaderElement;
import org.apache.http.HeaderElementIterator;
import org.apache.http.HttpEntity;  
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;  
import org.apache.http.client.config.RequestConfig;  
import org.apache.http.client.entity.UrlEncodedFormEntity;  
import org.apache.http.client.methods.CloseableHttpResponse;  
import org.apache.http.client.methods.HttpGet;  
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;  
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeaderElementIterator;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HTTP;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ovopark.boot.kit.log.LogKit;
import com.ovopark.boot.kit.reflect.ReflectKit;
import com.ovopark.boot.utils.lang.ConvertUtils;

import java.io.File;
import java.io.IOException;  
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.nio.charset.Charset;  
import java.util.ArrayList;  
import java.util.HashMap;  
import java.util.List;  
import java.util.Map;  
/**
 * @ClassName:  OvoparkHttpClientKit   
 * @Description:TODO(HttpClient 封装)   
 * @author: Remiel_Mercy 
 * @date:   2020年4月7日 下午2:17:23   
 *     
 * @Copyright: 2020 www.ovopark.com Inc. All rights reserved.
 */
public class OvoparkHttpClientKit {
	
	
	private static final Logger logger = LoggerFactory.getLogger(OvoparkHttpClientKit.class);

	
    private static PoolingHttpClientConnectionManager  connMag;
    private static RequestConfig requestConfig;  
	private static final int SocketTimeout = 30 * 1000;  //设置请求超时30秒钟 根据业务调整 
	private static final int ConnectTimeout = 10 * 1000;  
	private static final int ConnectionRequestTimeout= 10 * 1000;  
	private static int maxThreadsTotal = 500;
	private static int maxThreadsPerHost = 50;
	
	private static CloseableHttpClient httpClient;
	
    static final String HTTPCLIENT_ERROR="APIGETWAY_HTTP_ERROR";
	
    
	private enum initHttp{
		instance;
		private OvoparkHttpClientKit t;
		initHttp(){
			t=new OvoparkHttpClientKit();
			// 设置连接池  
			connMag=new PoolingHttpClientConnectionManager();
			connMag.setMaxTotal(maxThreadsTotal);//总的连接数  
			connMag.setDefaultMaxPerRoute(maxThreadsPerHost);//每个host的最大连接数  ,即某个路由的最大并发
	        RequestConfig.Builder configBuilder = RequestConfig.custom();  
	        // 设置连接超时  
	        configBuilder.setConnectTimeout(ConnectTimeout);  
	        // 设置读取超时  
	        configBuilder.setSocketTimeout(SocketTimeout);  
	        // 设置从连接池获取连接实例的超时  
	        configBuilder.setConnectionRequestTimeout(ConnectionRequestTimeout);  
	        requestConfig = configBuilder.build();  
	        
	        ConnectionKeepAliveStrategy myStrategy = new ConnectionKeepAliveStrategy() {
	            @Override
	            public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
	                HeaderElementIterator it = new BasicHeaderElementIterator
	                    (response.headerIterator(HTTP.CONN_KEEP_ALIVE));
	                while (it.hasNext()) {
	                    HeaderElement he = it.nextElement();
	                    String param = he.getName();
	                    String value = he.getValue();
	                    if (value != null && param.equalsIgnoreCase
	                       ("timeout")) {
	                        return Long.parseLong(value) * 1000;
	                    }
	                }
	                return 60 * 1000;//如果没有约定，则默认定义时长为60s
	            }
	        };
	        
	        httpClient = HttpClients.custom()
	                .setConnectionManager(connMag)
	                .setKeepAliveStrategy(myStrategy)
	                .setDefaultRequestConfig(requestConfig)
	                .build();
		}
		private OvoparkHttpClientKit init(){
	        return t;
	    }
	}
	public static OvoparkHttpClientKit init() {
		return initHttp.instance.init();
	} 
    public  String doGet(String url) {  
        return doGet(url, new HashMap<String, Object>());  
    }  
    /**
     * 发送 GET 请求（HTTP），K-V形式
     * @param url
     * @param params
     * @return
     */  
	public  String doGet(String url, Map<String, Object> params) {  
		return doGet(url,params,null);
    }  
	
	@SuppressWarnings("unchecked")
	public  String doGet(String url, Map<String, Object> params,Map<String,Object> headers) {  
        String result = null;  
        try {  
            String apiUrl = url;  
            StringBuffer param = new StringBuffer();  
            int i = 0;  
            for (String key : params.keySet()) {  
                if (i == 0)  
                    param.append("?");  
                else  
                    param.append("&");  
        		param.append(key).append("=").append(URLEncoder.encode(ConvertUtils.toStr(params.get(key)), "utf-8")); //防止get请求参数带有类似空格等字符
                i++;  
            }  
            apiUrl += param;  
            HttpGet httpGet = new HttpGet(apiUrl);  
            if(headers!=null){
            	for (Object obj : headers.entrySet()) {    
    				Map.Entry<String, String> entry = (Map.Entry<String, String>) obj;  
    				String key=entry.getKey();
    				String value=entry.getValue();
    				httpGet.addHeader(key, value);
    		    }  
            }
            HttpResponse response = httpClient.execute(httpGet);  
//            int statusCode = response.getStatusLine().getStatusCode();  
            HttpEntity entity = response.getEntity();  
            if (entity != null) {  
                InputStream instream = entity.getContent();  
                result = IOUtils.toString(instream, "UTF-8");  
            }  
        } catch (IOException e) {  
            e.printStackTrace();  
        }  
        return result;  
	}
    public  String doPost(String apiUrl) {  
        return doPost(apiUrl, new HashMap<String, Object>());  
    }  
    /**
     * 发送 POST 请求（HTTP），K-V形式
     * @param apiUrl API接口URL
     * @param params 参数map
     * @return
     */  
    public  String doPost(String apiUrl, Map<String, Object> params) {  
    	return doPost(apiUrl,params,null);
    }  
    /**
     * 发送 POST 请求（HTTP），K-V形式
     * @param apiUrl API接口URL
     * @param params 参数map
     * @return
     */  
    @SuppressWarnings("unchecked")
	public  String doPost(String apiUrl, Map<String, Object> params,Map<String,Object> headers) {  
        String httpStr = null;  
        HttpPost httpPost = new HttpPost(apiUrl);  
        CloseableHttpResponse response = null;  
        try {  
            List<NameValuePair> pairList = new ArrayList<>(params.size());  
            for (Map.Entry<String, Object> entry : params.entrySet()) {  
                NameValuePair pair = new BasicNameValuePair(entry.getKey(), entry  
                        .getValue().toString());  
                pairList.add(pair);  
            }  
            if(headers!=null){
            	for (Object obj : headers.entrySet()) {    
    				Map.Entry<String, String> entry = (Map.Entry<String, String>) obj;  
    				String key=entry.getKey();
    				String value=entry.getValue();
    				httpPost.addHeader(key, value);
    		    }  
            }
            httpPost.setEntity(new UrlEncodedFormEntity(pairList, Charset.forName("UTF-8")));  
            response = httpClient.execute(httpPost);  
//            int statusCode = response.getStatusLine().getStatusCode();  
//            LogKit.info("~执行状态码 : " + statusCode);
            HttpEntity entity = response.getEntity();  
            httpStr = EntityUtils.toString(entity, "UTF-8");  
        } catch (IOException e) {  
        	 logger.info("doPost error:{}",e);
            e.printStackTrace();  
            httpStr=HTTPCLIENT_ERROR;
        } finally {  
            if (response != null) {  
                try {  
                    EntityUtils.consume(response.getEntity());  
                } catch (IOException e) {  
                    e.printStackTrace();  
                }  
            }  
        }  
        return httpStr;  
    }  

    public  String doPost(String apiUrl, Object obj) {  
        String httpStr = null;  
        HttpPost httpPost = new HttpPost(apiUrl);  
        CloseableHttpResponse response = null;  
        try {  
    		Class<?> clazz=obj.getClass();
    		Field[] fields = ReflectKit.getNeedFields(clazz);
            List<NameValuePair> pairList = new ArrayList<>(fields.length);  
            for (Field field : fields) {
      		  // 抑制Java对修饰符的检查
			      field.setAccessible(true);
			      String fieldName=field.getName();
			      Object o=ReflectKit.getFieldValue(obj, fieldName);
			      String value=null;
			      if(ReflectKit.isLangType(o)) {
			    	  value=ConvertUtils.toStr(o,"");
			      }else {
			    	  value=JSON.toJSONString(o);
			      }
			      NameValuePair pair = new BasicNameValuePair(fieldName ,value);  
	              pairList.add(pair); 
            }
            httpPost.setEntity(new UrlEncodedFormEntity(pairList, Charset.forName("UTF-8")));  
            response = httpClient.execute(httpPost);  
//            int statusCode = response.getStatusLine().getStatusCode();  
//            LogKit.info("~执行状态码 : " + statusCode);
            HttpEntity entity = response.getEntity();  
            httpStr = EntityUtils.toString(entity, "UTF-8");  
        } catch (IOException e) {  
            e.printStackTrace();  
            httpStr=HTTPCLIENT_ERROR;
        } finally {  
            if (response != null) {  
                try {  
                    EntityUtils.consume(response.getEntity());  
                } catch (IOException e) {  
                    e.printStackTrace();  
                }  
            }  
        }  
        return httpStr;  
    }
    /**
     * 将文件提交至文件服务器
     */
    public String postFile(String apiUrl, File file) {
          String httpStr = null;  
          HttpPost httpPost = new HttpPost(apiUrl);  
          CloseableHttpResponse response = null;  
          try {  
              MultipartEntityBuilder mEntityBuilder = MultipartEntityBuilder.create();
              mEntityBuilder.addBinaryBody("file", file);
              httpPost.setEntity(mEntityBuilder.build()); 
              response = httpClient.execute(httpPost);  
              HttpEntity entity = response.getEntity();  
              httpStr = EntityUtils.toString(entity, "UTF-8");  
          } catch (IOException e) {  
              e.printStackTrace();  
              httpStr=HTTPCLIENT_ERROR;
          } finally {  
              if (response != null) {  
                  try {  
                      EntityUtils.consume(response.getEntity());  
                  } catch (IOException e) {  
                      e.printStackTrace();  
                  }  
              }  
          }  
          return httpStr;  
    }
    
    
	@SuppressWarnings("unchecked")
	public  String doGetJson(String apiUrl, JSONObject  jsonObj,Map<String,String> headers) {  
        String httpStr = null;  
        CloseableHttpResponse response = null;  
        try {  
            if (!jsonObj.isEmpty()) {
                for (String key : jsonObj.keySet()) {
                    if (apiUrl.indexOf('?') == -1) {
                  	  apiUrl += "?" + key+"="+jsonObj.get(key);
                    } else {
                  	  apiUrl += "&" + key+"="+jsonObj.get(key);
                    }
                }

            }
            HttpGet httpGet = new HttpGet(apiUrl);  
            httpGet.setHeader("Content-type", "application/json");   
            if(headers!=null){
            	for (Object obj : headers.entrySet()) {    
    				Map.Entry<String, String> entry = (Map.Entry<String, String>) obj;  
    				String key=entry.getKey();
    				String value=entry.getValue();
    				httpGet.addHeader(key, value);
    		    }  
            }
            response = httpClient.execute(httpGet);  
//            int statusCode = response.getStatusLine().getStatusCode();  
//            LogKit.info("~doGetJson执行状态码 : " + statusCode);
            HttpEntity entity = response.getEntity();  
            httpStr = EntityUtils.toString(entity, "UTF-8"); 
        } catch (IOException e) {  
            e.printStackTrace();  
            httpStr=HTTPCLIENT_ERROR;
        }finally {  
            if (response != null) {  
                try {  
                    EntityUtils.consume(response.getEntity());  
                } catch (IOException e) {  
                    e.printStackTrace();  
                }  
            }  
        }  
        return httpStr;     
    }  
	
	 @SuppressWarnings("unchecked")
		public  String doPostJson(String apiUrl, String json,Map<String, String> headers) {  
	          String httpStr = null;  
	          CloseableHttpResponse response = null;  
	          try {  
	              HttpPost httpPost = new HttpPost(apiUrl);  
	              httpPost.setHeader("Content-type", "application/json");  
	              if(headers!=null){
	              	for (Object obj : headers.entrySet()) {    
	      				Map.Entry<String, String> entry = (Map.Entry<String, String>) obj;  
	      				String key=entry.getKey();
	      				String value=entry.getValue();
	      				httpPost.addHeader(key, value);
	      		    }  
	              }
	              StringEntity stringEntity = new StringEntity(json,"UTF-8");//解决中文乱码问题  
	              stringEntity.setContentEncoding("UTF-8");  
	              stringEntity.setContentType("application/json");  
	              httpPost.setEntity(stringEntity);  
	              response = httpClient.execute(httpPost);  
//	              int statusCode = response.getStatusLine().getStatusCode();  
//	              LogKit.info("~doPostJson执行状态码 : " + statusCode);
	              HttpEntity entity = response.getEntity();  
	              httpStr = EntityUtils.toString(entity, "UTF-8");  
	          } catch (IOException e) {  
	              e.printStackTrace();  
	              httpStr=HTTPCLIENT_ERROR;
	          } finally {  
	              if (response != null) {  
	                  try {  
	                      EntityUtils.consume(response.getEntity());  
	                  } catch (IOException e) {  
	                      e.printStackTrace();  
	                  }  
	              }  
	          }  
	          return httpStr;  
	    }
		
		
	    @SuppressWarnings("unchecked")
		public  String doPutJson(String apiUrl, String json,Map<String, String> headers) {  
	          String httpStr = null;  
	          CloseableHttpResponse response = null;  
	          try {  
	              HttpPut httpput = new HttpPut(apiUrl);
	        	  httpput.setHeader("Content-type", "application/json");  
	              if(headers!=null){
	              	for (Object obj : headers.entrySet()) {    
	      				Map.Entry<String, String> entry = (Map.Entry<String, String>) obj;  
	      				String key=entry.getKey();
	      				String value=entry.getValue();
	      				httpput.addHeader(key, value);
	      		    }  
	              }
	              StringEntity stringEntity = new StringEntity(json,"UTF-8");//解决中文乱码问题  
	              stringEntity.setContentEncoding("UTF-8");  
	              stringEntity.setContentType("application/json");  
	              httpput.setEntity(stringEntity);  
	              response = httpClient.execute(httpput);  
//	              int statusCode = response.getStatusLine().getStatusCode();  
//	              LogKit.info("~doPutJson执行状态码 : " + statusCode);
	              HttpEntity entity = response.getEntity();  
	              httpStr = EntityUtils.toString(entity, "UTF-8");  
	          } catch (IOException e) {  
	              e.printStackTrace();  
	              httpStr=HTTPCLIENT_ERROR;
	          } finally {  
	              if (response != null) {  
	                  try {  
	                      EntityUtils.consume(response.getEntity());  
	                  } catch (IOException e) {  
	                      e.printStackTrace();  
	                  }  
	              }  
	          }  
	          return httpStr;  
	    }

		@SuppressWarnings("unchecked")
		public  String doDeleteJson(String apiUrl, String json,Map<String,String> headers) {  
	        String httpStr = null;  
	        CloseableHttpResponse response = null;  
	        try {  
	        	HttpDeleteKit httpdelete = new HttpDeleteKit(apiUrl);  
	        	httpdelete.setHeader("Content-type", "application/json");  
	            if(headers!=null){
	            	for (Object obj : headers.entrySet()) {    
	    				Map.Entry<String, String> entry = (Map.Entry<String, String>) obj;  
	    				String key=entry.getKey();
	    				String value=entry.getValue();
	    				httpdelete.addHeader(key, value);
	    		    }  
	            }
	            StringEntity stringEntity = new StringEntity(json,"UTF-8");//解决中文乱码问题  
	            stringEntity.setContentEncoding("UTF-8");  
	            stringEntity.setContentType("application/json");  
	            httpdelete.setEntity(stringEntity);  
	            response = httpClient.execute(httpdelete);  
//	            int statusCode = response.getStatusLine().getStatusCode();  
//	            LogKit.info("~doDeleteJson执行状态码 : " + statusCode);
	            HttpEntity entity = response.getEntity();  
	            httpStr = EntityUtils.toString(entity, "UTF-8"); 
	        } catch (IOException e) {  
	            e.printStackTrace();  
	            httpStr=HTTPCLIENT_ERROR;
	        } finally {  
	            if (response != null) {  
	                try {  
	                    EntityUtils.consume(response.getEntity());  
	                } catch (IOException e) {  
	                    e.printStackTrace();  
	                }  
	            }  
	        }  
	        return httpStr;  
	    } 

}
