package com.ovopark.boot.kit.json.serializer;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;

/**
 * 
    * @ClassName: CoCoJsonDateTimeSerializer
    * @Description: TODO(Json时间转换器)
    * @author Remiel_Mercy xuefei_fly@126.com
    * @date  2019年1月2日 下午5:52:07 
    *
 */
public class CoCoJsonDateTimeSerializer extends JsonSerializer<Date>{
	   private SimpleDateFormat dateFormat=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");  
		 
	   @Override  
	   public void serialize(Date date, JsonGenerator gen, SerializerProvider provider)  
	           throws IOException, JsonProcessingException {  
	       String value = dateFormat.format(date);  
	       gen.writeString(value);  
	   }  
}
