package com.ovopark.boot.kit.lang;

import java.util.Enumeration;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import com.ovopark.boot.kit.support.WafRequestWrapper;



public class HttpKit {
    /**
     * 获取 HttpServletRequest
     */
    public static HttpServletResponse getResponse() {
        HttpServletResponse response = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getResponse();
        return response;
    }

    /**
     * 获取 包装防Xss Sql注入的 HttpServletRequest
     * @return request
     */
    public static HttpServletRequest getRequest() {
        HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
        return new WafRequestWrapper(request);
    }
    /**
     * 将所有request转换成一行字符串，用空格分割
     */
    @SuppressWarnings("rawtypes")
	public static String getParameters(HttpServletRequest request){
    	Enumeration enu=request.getParameterNames();  
    	StringBuilder sb =new StringBuilder();
    	while(enu.hasMoreElements()){  
    		String paraName=(String)enu.nextElement();  
    		sb.append(paraName).append("=").append(request.getParameter(paraName)).append("  ");
    	}
    	return sb.toString();
    }
}
