package com.ovopark.boot.kit.lang;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @ClassName:  PlacehHolderKit   
 * @Description:TODO(占位符工具类)   
 * @author: Remiel_Mercy 
 * @date:   2021年5月17日 下午3:47:56   
 *     
 * @Copyright: 2021 www.ovopark.com Inc. All rights reserved.
 */
public class PlacehHolderKit {
	
	
	/**
	 * @Title: getDollar   
	 * @Description: TODO(替换${}内容)   
	 * @param: @param soap 原始信息
	 * @param: @param map  根据原始信息占位符中的内容作为key,获取替换进占位符中的内容
	 * @param: @return      
	 * @return: String      
	 * @throws
	 */
	public static String getDollar(String soap, Map<String, Object> map) {
		String regex = "\\$\\{(.*?)\\}";
		return getMes( soap,regex, "${", "}", map);
	}
	
	/**
     *  组装信息 
     * @param soap 原始信息
     * @param regex  条件 占位符
     * @param startStr  删除掉的内容
     * @param endStr 删除掉的内容
     * @param map 根据原始信息占位符中的内容作为key,获取替换进占位符中的内容
     * @return
     */
    public static String getMes(String soap, String regex, String startStr, String endStr, Map<String, Object> map) {
        List<String> subUtil = getSubUtil(soap, regex);
        for (String s : subUtil) {
            if (map.containsKey(s) && null != map.get(s)) {
                soap = soap.replace(startStr + s + endStr, map.get(s).toString());
            }
        }
        return soap;
    }

    private static List<String> getSubUtil(String soap, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(soap);
        List<String> list = new ArrayList<>();
        int i = 1;
        while (matcher.find()) {
            list.add(matcher.group(i));
        }
        return list;
    }
    
    public static void main(String[] args) {
        String regex = "\\$\\{(.*?)\\}";
        Map<String, Object> map = new HashMap<>();
        map.put("username", "xuefei");
        map.put("password", "1d4787cb0fc2430f47d282a68b227469");
        String mes =getMes("http://business.ovopark.com/api/business/base/user/v1/login?username=${username}&password=${password}", regex, "${", "}", map);
        System.out.println(mes);
    }
    
}
