package com.ovopark.boot.kit.log;

import java.io.PrintWriter;
import java.io.StringWriter;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @ClassName: LogKit
 * @Description: TODO(Slf4j日志工具类)
 * @author Remiel_Mercy xuefei_fly@126.com
 * @date 2017年8月15日 下午9:36:04
 */
public class LogKit {
	public static Logger log = LoggerFactory.getLogger(LogKit.class);

	// 打印警告
	public static void warn(Object obj) {
		try {
			/*** 获取输出信息的代码的位置 ***/
			String location = "";
			StackTraceElement[] stacks = Thread.currentThread().getStackTrace();
			location = stacks[2].getClassName() + "." + stacks[2].getMethodName();
			/*** 是否是异常 ***/
			if (obj instanceof Exception) {
				Exception e = (Exception) obj;
				StringWriter sw = new StringWriter();
				e.printStackTrace(new PrintWriter(sw, true));
				String str = sw.toString();
				log.warn(location + str);
			} else {
				log.warn(location + obj.toString());
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	//打印信息
	public static void info(Object obj) {
		try {
			/*** 获取输出信息的代码的位置 ***/
			String location = "";
			StackTraceElement[] stacks = Thread.currentThread().getStackTrace();
			location = stacks[2].getClassName() + "." + stacks[2].getMethodName();
			/*** 是否是异常 ***/
			if (obj instanceof Exception) {
				Exception e = (Exception) obj;
				StringWriter sw = new StringWriter();
				e.printStackTrace(new PrintWriter(sw, true));
				String str = sw.toString();
				log.info(location + str);
			} else {
				log.info(location + obj.toString());
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	//打印错误
	public static void error(Object obj) {
		try {
			/*** 获取输出信息的代码的位置 ***/
			String location = "";
			StackTraceElement[] stacks = Thread.currentThread().getStackTrace();
			location = stacks[2].getClassName() + "." + stacks[2].getMethodName();
			/*** 是否是异常 ***/
			if (obj instanceof Exception) {
				Exception e = (Exception) obj;
				StringWriter sw = new StringWriter();
				e.printStackTrace(new PrintWriter(sw, true));
				String str = sw.toString();
				log.error(location + str);
			} else {
				log.error(location + obj.toString());
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
