package com.ovopark.boot.utils.lang;

import java.util.Arrays;
import java.util.List;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.ovopark.boot.kit.bean.Authenticator;


public class TokenUtils {
	final static String shopwebsalt="kedacom.com";
	
	public static String getUserId(String ticket){
		try {
			if(ticket.contains(" ")) {
				ticket=getToken(ticket);
			}
			// 解密 
			byte[] decryptResult = AesUtil.decrypt(ticket, shopwebsalt); 
			String result=new String(decryptResult);
			System.out.println("解密后：" +result); 
			//24988,jia,f379eaf3c831b04de153469d1bec345e
			String id=result.split(",")[0];
			return id;
		} catch (Exception e) {
			return null;
		}
	}
	
	public static String getUserName(String ticket){
		try {
			if(ticket.contains(" ")) {
				ticket=getToken(ticket);
			}
			// 解密 
			byte[] decryptResult = AesUtil.decrypt(ticket, shopwebsalt); 
			String result=new String(decryptResult);
			System.out.println("解密后：" +result); 
			//24988,jia,f379eaf3c831b04de153469d1bec345e
			String userName=result.split(",")[1];
			return userName;
		} catch (Exception e) {
			return null;
		}
	}
	public static  boolean decryptToken(String token){
		try {
			// 解密 
			byte[] decryptResult = AesUtil.decrypt(token, shopwebsalt); 
		    //24988,jia,f379eaf3c831b04de153469d1bec345e
			String result=new String(decryptResult);
			List<String> list=Splitter.on(",").splitToList(result);
			return list.size()==3;
		} catch (Exception e) {
			return false;
		}
	}
	public static Authenticator ConvertToAuthenticator(String authenticator){
		try {	
			List<String> list=Splitter.on(" ").splitToList(authenticator);
			if(list.size()>0){
				Authenticator auth=new Authenticator();
				auth.setToken(list.get(0));
				auth.setClient(list.get(1));
				auth.setVersion(list.get(2));
				auth.setLang(list.get(3));
				auth.setTimeZone(list.get(4));
				return auth;
			}
			return null;
		} catch (Exception e) {
			return null;
		}
	}
	
	public static String getToken(String authenticator){
		try {	
			List<String> list=Splitter.on(" ").splitToList(authenticator);
			if(list.size()>0){
				return list.get(0);
			}
			return null;
		} catch (Exception e) {
			return null;
		}
	}
	
	public static boolean PrivilegedUsers(String authenticator,List<String> userlist) {
		String userName=getUserName(authenticator);
		if(userlist.contains(userName)) {
			return true;
		}
		return false;
	}
	
	public static String getAuthenticator( Object userId,Object username,Object password) {
		String s=Joiner.on(",").join(Arrays.asList(userId, username, password));
		String result=AesUtil.encrypttoStr(s, shopwebsalt);
		return result;
	}
	
	public static void main(String[] args) {
		String authenticator="3610C63CD0770260D4FD98836E1B3C952C91814703EB58E7BF73EC6D441678CD9AD36482FEFFFE484D14142413D08CE0";
		System.out.println(TokenUtils.getUserName(authenticator));
//		System.out.println(userId);
//		System.out.println(getAuthenticator("1","root","8e0a3adfcbb3b46c0210a9f268c35352"));
//		System.out.println(getAuthenticator("61692","xuefei","1d4787cb0fc2430f47d282a68b227469"));
//		System.out.println(getAuthenticator("512504798","xuefei","1d4787cb0fc2430f47d282a68b227469"));
	}
}
