/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.boot.kit.hardware;

import com.ovopark.boot.kit.http.IPKit;
import com.ovopark.boot.kit.lang.StrKit;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Scanner;
import java.util.stream.Collectors;

public class ServerKit {
    public static List<String> getIpAddress() {
        List<InetAddress> inetAddresses = ServerKit.getAllInetAddress();
        List<String> result = inetAddresses.stream().map(InetAddress::getHostAddress).distinct().map(String::toLowerCase).collect(Collectors.toList());
        return result;
    }

    public static List<String> getMacAddress() {
        List<InetAddress> inetAddresses = ServerKit.getAllInetAddress();
        List<String> result = inetAddresses.stream().map(inetAddr -> ServerKit.getMacByInetAddress(inetAddr)).distinct().collect(Collectors.toList());
        return result;
    }

    public static String getCpuSerial() {
        return IPKit.isWindowsOS() ? ServerKit.getCPUSerialWin() : ServerKit.getCPUSerialLinux();
    }

    public static String getMainBoardSerial() {
        return IPKit.isWindowsOS() ? ServerKit.getMainBoardSerialWin() : ServerKit.getMainBoardSerialLinux();
    }

    private static List<InetAddress> getAllInetAddress() {
        ArrayList<InetAddress> result = new ArrayList<InetAddress>();
        try {
            Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
            while (netInterfaces.hasMoreElements()) {
                NetworkInterface iface = netInterfaces.nextElement();
                Enumeration<InetAddress> inetAddresses = iface.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress inetAddr = inetAddresses.nextElement();
                    if (inetAddr.isLoopbackAddress() || inetAddr.isLinkLocalAddress() || inetAddr.isMulticastAddress()) continue;
                    result.add(inetAddr);
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return result;
    }

    private static String getMacByInetAddress(InetAddress inetAddr) {
        try {
            byte[] mac = NetworkInterface.getByInetAddress(inetAddr).getHardwareAddress();
            StringBuffer stringBuffer = new StringBuffer();
            int i = 0;
            while (i < mac.length) {
                String temp;
                if (i != 0) {
                    stringBuffer.append("-");
                }
                if ((temp = Integer.toHexString(mac[i] & 0xFF)).length() == 1) {
                    stringBuffer.append("0" + temp);
                } else {
                    stringBuffer.append(temp);
                }
                ++i;
            }
            return stringBuffer.toString().toUpperCase();
        }
        catch (SocketException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String getCPUSerialWin() {
        try {
            String serialNumber = "";
            Process process = Runtime.getRuntime().exec("wmic cpu get processorid");
            process.getOutputStream().close();
            Scanner scanner = new Scanner(process.getInputStream());
            if (scanner != null && scanner.hasNext()) {
                scanner.next();
            }
            if (scanner.hasNext()) {
                serialNumber = scanner.next().trim();
            }
            scanner.close();
            return serialNumber;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String getCPUSerialLinux() {
        try {
            String serialNumber = "";
            String[] shell = new String[]{"/bin/bash", "-c", "dmidecode -t processor | grep 'ID' | awk -F ':' '{print $2}' | head -n 1"};
            Process process = Runtime.getRuntime().exec(shell);
            process.getOutputStream().close();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = reader.readLine().trim();
            if (!StrKit.isBlank(line)) {
                serialNumber = line;
            }
            reader.close();
            return serialNumber;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String getMainBoardSerialWin() {
        try {
            String serialNumber = "";
            Process process = Runtime.getRuntime().exec("wmic baseboard get serialnumber");
            process.getOutputStream().close();
            Scanner scanner = new Scanner(process.getInputStream());
            if (scanner.hasNext()) {
                scanner.next();
            }
            if (scanner.hasNext()) {
                serialNumber = scanner.next().trim();
            }
            scanner.close();
            return serialNumber;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String getMainBoardSerialLinux() {
        try {
            String serialNumber = "";
            String[] shell = new String[]{"/bin/bash", "-c", "dmidecode | grep 'Serial Number' | awk -F ':' '{print $2}' | head -n 1"};
            Process process = Runtime.getRuntime().exec(shell);
            process.getOutputStream().close();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = reader.readLine().trim();
            if (!StrKit.isBlank(line)) {
                serialNumber = line;
            }
            reader.close();
            return serialNumber;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        System.out.println(ServerKit.getIpAddress());
        System.out.println(ServerKit.getMacAddress());
        System.out.println(ServerKit.getCpuSerial());
        System.out.println(ServerKit.getMainBoardSerial());
    }
}

