/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.boot.kit.http;

import com.alibaba.fastjson.JSON;
import com.ovopark.boot.kit.log.LogKit;
import com.ovopark.boot.kit.reflect.ReflectKit;
import com.ovopark.boot.utils.lang.ConvertUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class HttpClientKit {
    private static PoolingHttpClientConnectionManager connMag;
    private static RequestConfig requestConfig;
    private static final int MAX_TIMEOUT = 10000;
    private static int maxThreadsTotal;
    private static int maxThreadsPerHost;
    static final String HTTPCLIENT_ERROR = "APIGETWAY_HTTP_ERROR";

    static {
        maxThreadsTotal = 500;
        maxThreadsPerHost = 50;
    }

    public static HttpClientKit init() {
        return initHttp.instance.init();
    }

    public String doGet(String url) {
        return this.doGet(url, new HashMap<String, Object>());
    }

    public String doGet(String url, Map<String, Object> params) {
        return this.doGet(url, params, null);
    }

    public String doGet(String url, Map<String, Object> params, Map<String, String> headers) {
        String result = null;
        try {
            String apiUrl = url;
            StringBuffer param = new StringBuffer();
            int i = 0;
            for (String key : params.keySet()) {
                if (i == 0) {
                    param.append("?");
                } else {
                    param.append("&");
                }
                param.append(key).append("=").append(URLEncoder.encode(ConvertUtils.toStr(params.get(key)), "utf-8"));
                ++i;
            }
            apiUrl = String.valueOf(apiUrl) + param;
            CloseableHttpClient httpclient = HttpClientBuilder.create().build();
            HttpGet httpGet = new HttpGet(apiUrl);
            if (headers != null) {
                Iterator<Map.Entry<String, String>> iterator = headers.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, String> obj;
                    Map.Entry<String, String> entry = obj = iterator.next();
                    String key = entry.getKey();
                    String value = entry.getValue();
                    httpGet.addHeader(key, value);
                }
            }
            HttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
            int statusCode = response.getStatusLine().getStatusCode();
            LogKit.info("~\u6267\u884c\u72b6\u6001\u7801 : " + statusCode);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                InputStream instream = entity.getContent();
                result = IOUtils.toString((InputStream)instream, (String)"UTF-8");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public String doPost(String apiUrl) {
        return this.doPost(apiUrl, new HashMap<String, Object>());
    }

    public String doPost(String apiUrl, Map<String, Object> params) {
        String httpStr;
        block13: {
            CloseableHttpClient httpClient = HttpClients.createDefault();
            httpStr = null;
            HttpPost httpPost = new HttpPost(apiUrl);
            CloseableHttpResponse response = null;
            try {
                try {
                    httpPost.setConfig(requestConfig);
                    httpPost.setHeader("Connection", "close");
                    ArrayList<BasicNameValuePair> pairList = new ArrayList<BasicNameValuePair>(params.size());
                    for (Map.Entry<String, Object> entry : params.entrySet()) {
                        String value = ConvertUtils.toStr(entry.getValue(), "");
                        BasicNameValuePair pair = new BasicNameValuePair(entry.getKey(), value);
                        pairList.add(pair);
                    }
                    httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairList, Charset.forName("UTF-8")));
                    response = httpClient.execute((HttpUriRequest)httpPost);
                    HttpEntity entity = response.getEntity();
                    httpStr = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                }
                catch (IOException e) {
                    e.printStackTrace();
                    httpStr = HTTPCLIENT_ERROR;
                    if (response == null) break block13;
                    try {
                        EntityUtils.consume((HttpEntity)response.getEntity());
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (response != null) {
                    try {
                        EntityUtils.consume((HttpEntity)response.getEntity());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return httpStr;
    }

    public String doPost(String apiUrl, Map<String, Object> params, Map<String, String> headers) {
        String httpStr;
        block15: {
            CloseableHttpClient httpClient = HttpClients.createDefault();
            httpStr = null;
            HttpPost httpPost = new HttpPost(apiUrl);
            CloseableHttpResponse response = null;
            try {
                try {
                    httpPost.setConfig(requestConfig);
                    httpPost.setHeader("Connection", "close");
                    ArrayList<BasicNameValuePair> pairList = new ArrayList<BasicNameValuePair>(params.size());
                    for (Map.Entry<String, Object> entry : params.entrySet()) {
                        String value = ConvertUtils.toStr(entry.getValue(), "");
                        BasicNameValuePair pair = new BasicNameValuePair(entry.getKey(), value);
                        pairList.add(pair);
                    }
                    if (headers != null) {
                        Iterator<Map.Entry<String, Object>> iterator = headers.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry<String, Object> obj;
                            Map.Entry<String, Object> entry = obj = iterator.next();
                            String key = entry.getKey();
                            String value = ConvertUtils.toStr(entry.getValue(), "");
                            httpPost.addHeader(key, value);
                        }
                    }
                    httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairList, Charset.forName("UTF-8")));
                    response = httpClient.execute((HttpUriRequest)httpPost);
                    int statusCode = response.getStatusLine().getStatusCode();
                    LogKit.info("~\u6267\u884c\u72b6\u6001\u7801 : " + statusCode);
                    HttpEntity entity = response.getEntity();
                    httpStr = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                }
                catch (IOException e) {
                    e.printStackTrace();
                    httpStr = HTTPCLIENT_ERROR;
                    if (response == null) break block15;
                    try {
                        EntityUtils.consume((HttpEntity)response.getEntity());
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (response != null) {
                    try {
                        EntityUtils.consume((HttpEntity)response.getEntity());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return httpStr;
    }

    public String doGetJson(String apiUrl, Map<String, Object> data, Map<String, String> headers) {
        String httpStr;
        block16: {
            httpStr = null;
            CloseableHttpResponse response = null;
            HttpGet httpGet = null;
            CloseableHttpClient httpClient = HttpClients.createDefault();
            try {
                try {
                    if (!data.isEmpty()) {
                        for (String string : data.keySet()) {
                            apiUrl = apiUrl.indexOf(63) == -1 ? String.valueOf(apiUrl) + "?" + string + "=" + data.get(string) : String.valueOf(apiUrl) + "&" + string + "=" + data.get(string);
                        }
                    }
                    httpGet = new HttpGet(apiUrl);
                    httpGet.setHeader("Content-type", "application/json");
                    if (headers != null) {
                        for (Object object : headers.entrySet()) {
                            Map.Entry entry = (Map.Entry)object;
                            String key = (String)entry.getKey();
                            String value = (String)entry.getValue();
                            httpGet.addHeader(key, value);
                        }
                    }
                    response = httpClient.execute((HttpUriRequest)httpGet);
                    int n = response.getStatusLine().getStatusCode();
                    LogKit.info("~doGetJson\u6267\u884c\u72b6\u6001\u7801 : " + n);
                    HttpEntity entity = response.getEntity();
                    httpStr = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    httpStr = HTTPCLIENT_ERROR;
                    httpGet.abort();
                    httpGet.releaseConnection();
                    if (response == null) break block16;
                    try {
                        EntityUtils.consume((HttpEntity)response.getEntity());
                        response.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                httpGet.abort();
                httpGet.releaseConnection();
                if (response != null) {
                    try {
                        EntityUtils.consume((HttpEntity)response.getEntity());
                        response.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return httpStr;
    }

    public String doPostJson(String apiUrl, Object json) {
        return this.doPostJson(apiUrl, json, null);
    }

    public String doPostJson(String apiUrl, Object json, Map<String, String> headers) {
        String httpStr;
        block14: {
            CloseableHttpClient httpClient = HttpClients.createDefault();
            httpStr = null;
            HttpPost httpPost = new HttpPost(apiUrl);
            CloseableHttpResponse response = null;
            try {
                try {
                    if (headers != null) {
                        Iterator<Map.Entry<String, String>> iterator = headers.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry<String, String> obj;
                            Map.Entry<String, String> entry = obj = iterator.next();
                            String key = entry.getKey();
                            String value = entry.getValue();
                            httpPost.addHeader(key, value);
                        }
                    }
                    httpPost.setConfig(requestConfig);
                    StringEntity stringEntity = new StringEntity(json.toString(), "UTF-8");
                    stringEntity.setContentEncoding("UTF-8");
                    stringEntity.setContentType("application/json");
                    httpPost.setEntity((HttpEntity)stringEntity);
                    response = httpClient.execute((HttpUriRequest)httpPost);
                    HttpEntity entity = response.getEntity();
                    System.out.println(response.getStatusLine().getStatusCode());
                    httpStr = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (response == null) break block14;
                    try {
                        EntityUtils.consume((HttpEntity)response.getEntity());
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (response != null) {
                    try {
                        EntityUtils.consume((HttpEntity)response.getEntity());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return httpStr;
    }

    public String doPost(String apiUrl, Object obj) {
        String httpStr;
        block13: {
            CloseableHttpClient httpClient = HttpClients.createDefault();
            httpStr = null;
            HttpPost httpPost = new HttpPost(apiUrl);
            CloseableHttpResponse response = null;
            try {
                try {
                    httpPost.setConfig(requestConfig);
                    httpPost.setHeader("Connection", "close");
                    Class<?> clazz = obj.getClass();
                    Field[] fields = ReflectKit.getNeedFields(clazz);
                    ArrayList<BasicNameValuePair> pairList = new ArrayList<BasicNameValuePair>(fields.length);
                    Field[] fieldArray = fields;
                    int n = fields.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Field field = fieldArray[n2];
                        field.setAccessible(true);
                        String fieldName = field.getName();
                        Object o = ReflectKit.getFieldValue(obj, fieldName);
                        String value = null;
                        value = ReflectKit.isLangType(o) ? ConvertUtils.toStr(o, "") : JSON.toJSONString((Object)o);
                        BasicNameValuePair pair = new BasicNameValuePair(fieldName, value);
                        pairList.add(pair);
                        ++n2;
                    }
                    httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairList, Charset.forName("UTF-8")));
                    response = httpClient.execute((HttpUriRequest)httpPost);
                    int statusCode = response.getStatusLine().getStatusCode();
                    LogKit.info("~\u6267\u884c\u72b6\u6001\u7801 : " + statusCode);
                    HttpEntity entity = response.getEntity();
                    httpStr = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                }
                catch (IOException e) {
                    e.printStackTrace();
                    httpStr = HTTPCLIENT_ERROR;
                    if (response == null) break block13;
                    try {
                        EntityUtils.consume((HttpEntity)response.getEntity());
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (response != null) {
                    try {
                        EntityUtils.consume((HttpEntity)response.getEntity());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return httpStr;
    }

    public String postFile(String apiUrl, File file) {
        String httpStr;
        block12: {
            CloseableHttpClient httpClient = HttpClients.createDefault();
            httpStr = null;
            HttpPost httpPost = new HttpPost(apiUrl);
            CloseableHttpResponse response = null;
            try {
                try {
                    httpPost.setConfig(requestConfig);
                    httpPost.setHeader("Connection", "close");
                    MultipartEntityBuilder mEntityBuilder = MultipartEntityBuilder.create();
                    mEntityBuilder.addBinaryBody("file", file);
                    httpPost.setEntity(mEntityBuilder.build());
                    response = httpClient.execute((HttpUriRequest)httpPost);
                    HttpEntity entity = response.getEntity();
                    httpStr = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                }
                catch (IOException e) {
                    e.printStackTrace();
                    httpStr = HTTPCLIENT_ERROR;
                    if (response == null) break block12;
                    try {
                        EntityUtils.consume((HttpEntity)response.getEntity());
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (response != null) {
                    try {
                        EntityUtils.consume((HttpEntity)response.getEntity());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return httpStr;
    }

    private static enum initHttp {
        instance;

        private HttpClientKit t = new HttpClientKit();

        private initHttp() {
            connMag = new PoolingHttpClientConnectionManager();
            connMag.setMaxTotal(maxThreadsTotal);
            connMag.setDefaultMaxPerRoute(maxThreadsPerHost);
            RequestConfig.Builder configBuilder = RequestConfig.custom();
            configBuilder.setConnectTimeout(10000);
            configBuilder.setSocketTimeout(10000);
            configBuilder.setConnectionRequestTimeout(10000);
            HttpClientKit.requestConfig = configBuilder.build();
        }

        private HttpClientKit init() {
            return this.t;
        }
    }
}

