/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.boot.kit.http;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ovopark.boot.kit.http.HttpDeleteKit;
import com.ovopark.boot.kit.reflect.ReflectKit;
import com.ovopark.boot.utils.lang.ConvertUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeaderElementIterator;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OvoparkHttpClientKit {
    private static final Logger logger = LoggerFactory.getLogger(OvoparkHttpClientKit.class);
    private static PoolingHttpClientConnectionManager connMag;
    private static RequestConfig requestConfig;
    private static final int SocketTimeout = 30000;
    private static final int ConnectTimeout = 10000;
    private static final int ConnectionRequestTimeout = 10000;
    private static int maxThreadsTotal;
    private static int maxThreadsPerHost;
    private static CloseableHttpClient httpClient;
    static final String HTTPCLIENT_ERROR = "APIGETWAY_HTTP_ERROR";

    static {
        maxThreadsTotal = 500;
        maxThreadsPerHost = 50;
    }

    public static OvoparkHttpClientKit init() {
        return initHttp.instance.init();
    }

    public String doGet(String url) {
        return this.doGet(url, new HashMap<String, Object>());
    }

    public String doGet(String url, Map<String, Object> params) {
        return this.doGet(url, params, null);
    }

    public String doGet(String url, Map<String, Object> params, Map<String, Object> headers) {
        String result = null;
        try {
            CloseableHttpResponse response;
            HttpEntity entity;
            String apiUrl = url;
            StringBuffer param = new StringBuffer();
            int i = 0;
            for (String key : params.keySet()) {
                if (i == 0) {
                    param.append("?");
                } else {
                    param.append("&");
                }
                param.append(key).append("=").append(URLEncoder.encode(ConvertUtils.toStr(params.get(key)), "utf-8"));
                ++i;
            }
            apiUrl = String.valueOf(apiUrl) + param;
            HttpGet httpGet = new HttpGet(apiUrl);
            if (headers != null) {
                Iterator<Map.Entry<String, Object>> iterator = headers.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, Object> obj;
                    Map.Entry<String, Object> entry = obj = iterator.next();
                    String key = entry.getKey();
                    String value = (String)entry.getValue();
                    httpGet.addHeader(key, value);
                }
            }
            if ((entity = (response = httpClient.execute((HttpUriRequest)httpGet)).getEntity()) != null) {
                InputStream instream = entity.getContent();
                result = IOUtils.toString((InputStream)instream, (String)"UTF-8");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public String doPost(String apiUrl) {
        return this.doPost(apiUrl, new HashMap<String, Object>());
    }

    public String doPost(String apiUrl, Map<String, Object> params) {
        return this.doPost(apiUrl, params, null);
    }

    public String doPost(String apiUrl, Map<String, Object> params, Map<String, Object> headers) {
        String httpStr;
        block15: {
            httpStr = null;
            HttpPost httpPost = new HttpPost(apiUrl);
            CloseableHttpResponse response = null;
            try {
                try {
                    ArrayList<BasicNameValuePair> pairList = new ArrayList<BasicNameValuePair>(params.size());
                    for (Map.Entry<String, Object> entry : params.entrySet()) {
                        BasicNameValuePair pair = new BasicNameValuePair(entry.getKey(), entry.getValue().toString());
                        pairList.add(pair);
                    }
                    if (headers != null) {
                        Iterator<Map.Entry<String, Object>> iterator = headers.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry<String, Object> obj;
                            Map.Entry<String, Object> entry = obj = iterator.next();
                            String key = entry.getKey();
                            String value = (String)entry.getValue();
                            httpPost.addHeader(key, value);
                        }
                    }
                    httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairList, Charset.forName("UTF-8")));
                    response = httpClient.execute((HttpUriRequest)httpPost);
                    HttpEntity entity = response.getEntity();
                    httpStr = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                }
                catch (IOException e) {
                    logger.info("doPost error:{}", (Throwable)e);
                    e.printStackTrace();
                    httpStr = HTTPCLIENT_ERROR;
                    if (response == null) break block15;
                    try {
                        EntityUtils.consume((HttpEntity)response.getEntity());
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (response != null) {
                    try {
                        EntityUtils.consume((HttpEntity)response.getEntity());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return httpStr;
    }

    public String doPost(String apiUrl, Object obj) {
        String httpStr;
        block13: {
            httpStr = null;
            HttpPost httpPost = new HttpPost(apiUrl);
            CloseableHttpResponse response = null;
            try {
                try {
                    Class<?> clazz = obj.getClass();
                    Field[] fields = ReflectKit.getNeedFields(clazz);
                    ArrayList<BasicNameValuePair> pairList = new ArrayList<BasicNameValuePair>(fields.length);
                    Field[] fieldArray = fields;
                    int n = fields.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Field field = fieldArray[n2];
                        field.setAccessible(true);
                        String fieldName = field.getName();
                        Object o = ReflectKit.getFieldValue(obj, fieldName);
                        String value = null;
                        value = ReflectKit.isLangType(o) ? ConvertUtils.toStr(o, "") : JSON.toJSONString((Object)o);
                        BasicNameValuePair pair = new BasicNameValuePair(fieldName, value);
                        pairList.add(pair);
                        ++n2;
                    }
                    httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairList, Charset.forName("UTF-8")));
                    response = httpClient.execute((HttpUriRequest)httpPost);
                    HttpEntity entity = response.getEntity();
                    httpStr = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                }
                catch (IOException e) {
                    e.printStackTrace();
                    httpStr = HTTPCLIENT_ERROR;
                    if (response == null) break block13;
                    try {
                        EntityUtils.consume((HttpEntity)response.getEntity());
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (response != null) {
                    try {
                        EntityUtils.consume((HttpEntity)response.getEntity());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return httpStr;
    }

    public String postFile(String apiUrl, File file) {
        String httpStr;
        block12: {
            httpStr = null;
            HttpPost httpPost = new HttpPost(apiUrl);
            CloseableHttpResponse response = null;
            try {
                try {
                    MultipartEntityBuilder mEntityBuilder = MultipartEntityBuilder.create();
                    mEntityBuilder.addBinaryBody("file", file);
                    httpPost.setEntity(mEntityBuilder.build());
                    response = httpClient.execute((HttpUriRequest)httpPost);
                    HttpEntity entity = response.getEntity();
                    httpStr = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                }
                catch (IOException e) {
                    e.printStackTrace();
                    httpStr = HTTPCLIENT_ERROR;
                    if (response == null) break block12;
                    try {
                        EntityUtils.consume((HttpEntity)response.getEntity());
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (response != null) {
                    try {
                        EntityUtils.consume((HttpEntity)response.getEntity());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return httpStr;
    }

    public String doGetJson(String apiUrl, JSONObject jsonObj, Map<String, String> headers) {
        String httpStr;
        block16: {
            httpStr = null;
            CloseableHttpResponse response = null;
            try {
                try {
                    if (!jsonObj.isEmpty()) {
                        for (String key : jsonObj.keySet()) {
                            apiUrl = apiUrl.indexOf(63) == -1 ? String.valueOf(apiUrl) + "?" + key + "=" + jsonObj.get((Object)key) : String.valueOf(apiUrl) + "&" + key + "=" + jsonObj.get((Object)key);
                        }
                    }
                    HttpGet httpGet = new HttpGet(apiUrl);
                    httpGet.setHeader("Content-type", "application/json");
                    if (headers != null) {
                        Iterator<Map.Entry<String, String>> iterator = headers.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry<String, String> obj;
                            Map.Entry<String, String> entry = obj = iterator.next();
                            String key = entry.getKey();
                            String value = entry.getValue();
                            httpGet.addHeader(key, value);
                        }
                    }
                    response = httpClient.execute((HttpUriRequest)httpGet);
                    HttpEntity entity = response.getEntity();
                    httpStr = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                }
                catch (IOException e) {
                    e.printStackTrace();
                    httpStr = HTTPCLIENT_ERROR;
                    if (response == null) break block16;
                    try {
                        EntityUtils.consume((HttpEntity)response.getEntity());
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (response != null) {
                    try {
                        EntityUtils.consume((HttpEntity)response.getEntity());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return httpStr;
    }

    public String doPostJson(String apiUrl, String json, Map<String, String> headers) {
        String httpStr;
        block14: {
            httpStr = null;
            CloseableHttpResponse response = null;
            try {
                try {
                    HttpPost httpPost = new HttpPost(apiUrl);
                    httpPost.setHeader("Content-type", "application/json");
                    if (headers != null) {
                        Iterator<Map.Entry<String, String>> iterator = headers.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry<String, String> obj;
                            Map.Entry<String, String> entry = obj = iterator.next();
                            String key = entry.getKey();
                            String value = entry.getValue();
                            httpPost.addHeader(key, value);
                        }
                    }
                    StringEntity stringEntity = new StringEntity(json, "UTF-8");
                    stringEntity.setContentEncoding("UTF-8");
                    stringEntity.setContentType("application/json");
                    httpPost.setEntity((HttpEntity)stringEntity);
                    response = httpClient.execute((HttpUriRequest)httpPost);
                    HttpEntity entity = response.getEntity();
                    httpStr = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                }
                catch (IOException e) {
                    e.printStackTrace();
                    httpStr = HTTPCLIENT_ERROR;
                    if (response == null) break block14;
                    try {
                        EntityUtils.consume((HttpEntity)response.getEntity());
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (response != null) {
                    try {
                        EntityUtils.consume((HttpEntity)response.getEntity());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return httpStr;
    }

    public String doPutJson(String apiUrl, String json, Map<String, String> headers) {
        String httpStr;
        block14: {
            httpStr = null;
            CloseableHttpResponse response = null;
            try {
                try {
                    HttpPut httpput = new HttpPut(apiUrl);
                    httpput.setHeader("Content-type", "application/json");
                    if (headers != null) {
                        Iterator<Map.Entry<String, String>> iterator = headers.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry<String, String> obj;
                            Map.Entry<String, String> entry = obj = iterator.next();
                            String key = entry.getKey();
                            String value = entry.getValue();
                            httpput.addHeader(key, value);
                        }
                    }
                    StringEntity stringEntity = new StringEntity(json, "UTF-8");
                    stringEntity.setContentEncoding("UTF-8");
                    stringEntity.setContentType("application/json");
                    httpput.setEntity((HttpEntity)stringEntity);
                    response = httpClient.execute((HttpUriRequest)httpput);
                    HttpEntity entity = response.getEntity();
                    httpStr = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                }
                catch (IOException e) {
                    e.printStackTrace();
                    httpStr = HTTPCLIENT_ERROR;
                    if (response == null) break block14;
                    try {
                        EntityUtils.consume((HttpEntity)response.getEntity());
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (response != null) {
                    try {
                        EntityUtils.consume((HttpEntity)response.getEntity());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return httpStr;
    }

    public String doDeleteJson(String apiUrl, String json, Map<String, String> headers) {
        String httpStr;
        block14: {
            httpStr = null;
            CloseableHttpResponse response = null;
            try {
                try {
                    HttpDeleteKit httpdelete = new HttpDeleteKit(apiUrl);
                    httpdelete.setHeader("Content-type", "application/json");
                    if (headers != null) {
                        Iterator<Map.Entry<String, String>> iterator = headers.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry<String, String> obj;
                            Map.Entry<String, String> entry = obj = iterator.next();
                            String key = entry.getKey();
                            String value = entry.getValue();
                            httpdelete.addHeader(key, value);
                        }
                    }
                    StringEntity stringEntity = new StringEntity(json, "UTF-8");
                    stringEntity.setContentEncoding("UTF-8");
                    stringEntity.setContentType("application/json");
                    httpdelete.setEntity((HttpEntity)stringEntity);
                    response = httpClient.execute((HttpUriRequest)httpdelete);
                    HttpEntity entity = response.getEntity();
                    httpStr = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                }
                catch (IOException e) {
                    e.printStackTrace();
                    httpStr = HTTPCLIENT_ERROR;
                    if (response == null) break block14;
                    try {
                        EntityUtils.consume((HttpEntity)response.getEntity());
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (response != null) {
                    try {
                        EntityUtils.consume((HttpEntity)response.getEntity());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return httpStr;
    }

    private static enum initHttp {
        instance;

        private OvoparkHttpClientKit t = new OvoparkHttpClientKit();

        private initHttp() {
            connMag = new PoolingHttpClientConnectionManager();
            connMag.setMaxTotal(maxThreadsTotal);
            connMag.setDefaultMaxPerRoute(maxThreadsPerHost);
            RequestConfig.Builder configBuilder = RequestConfig.custom();
            configBuilder.setConnectTimeout(10000);
            configBuilder.setSocketTimeout(30000);
            configBuilder.setConnectionRequestTimeout(10000);
            OvoparkHttpClientKit.requestConfig = configBuilder.build();
            ConnectionKeepAliveStrategy myStrategy = new ConnectionKeepAliveStrategy(){

                public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                    BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
                    while (it.hasNext()) {
                        HeaderElement he = it.nextElement();
                        String param = he.getName();
                        String value = he.getValue();
                        if (value == null || !param.equalsIgnoreCase("timeout")) continue;
                        return Long.parseLong(value) * 1000L;
                    }
                    return 60000L;
                }
            };
            httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connMag).setKeepAliveStrategy(myStrategy).setDefaultRequestConfig(requestConfig).build();
        }

        private OvoparkHttpClientKit init() {
            return this.t;
        }
    }
}

