/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.boot.kit.id.uuid;

import com.ovopark.boot.kit.id.IdKit;
import com.ovopark.boot.kit.lang.StrKit;
import java.net.InetAddress;
import java.util.UUID;

public class UUIdUtils {
    private static final int IP;
    private static String sep;
    private static short counter;
    private static final int JVM;
    private static final String default_bit = "88";

    static {
        int ipadd;
        sep = "";
        try {
            ipadd = Integer.valueOf(InetAddress.getLocalHost().getAddress().toString());
        }
        catch (Exception e) {
            ipadd = 0;
        }
        IP = ipadd;
        counter = 0;
        JVM = (int)(System.currentTimeMillis() >>> 8);
    }

    public static String getEasyUUID() {
        UUID uuid = UUID.randomUUID();
        return uuid.toString().replace("-", "");
    }

    public static String getIntricateUUID(String bit) {
        bit = StrKit.isBlank(bit) ? default_bit : bit;
        return String.valueOf(bit) + UUIdUtils.format(UUIdUtils.getIP()) + sep + UUIdUtils.format(UUIdUtils.getJVM()) + sep + UUIdUtils.format(UUIdUtils.getHiTime()) + sep + UUIdUtils.format(UUIdUtils.getLoTime()) + sep + UUIdUtils.format(UUIdUtils.getCount());
    }

    private static String format(int intval) {
        String formatted = Integer.toHexString(intval);
        StringBuffer buf = new StringBuffer("00000000");
        buf.replace(8 - formatted.length(), 8, formatted);
        return buf.toString();
    }

    private static String format(short shortval) {
        String formatted = Integer.toHexString(shortval);
        StringBuffer buf = new StringBuffer("0000");
        buf.replace(4 - formatted.length(), 4, formatted);
        return buf.toString();
    }

    private static int getJVM() {
        return JVM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static short getCount() {
        Class<IdKit> clazz = IdKit.class;
        synchronized (IdKit.class) {
            if (counter < 0) {
                counter = 0;
            }
            short s = counter;
            counter = (short)(s + 1);
            // ** MonitorExit[var0] (shouldn't be in output)
            return s;
        }
    }

    private static int getIP() {
        return IP;
    }

    private static short getHiTime() {
        return (short)(System.currentTimeMillis() >>> 32);
    }

    private static int getLoTime() {
        return (int)System.currentTimeMillis();
    }

    public static void main(String[] args) {
        int i = 0;
        while (i < 100) {
            System.out.println(UUIdUtils.getIntricateUUID(null));
            ++i;
        }
    }
}

