/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.boot.kit.io;

import com.ovopark.boot.exception.CoCoException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileKit {
    protected static final Logger log = LoggerFactory.getLogger(FileKit.class);
    private static final String jar_join = "!/";
    private static final String jar = "jar:";

    public static Properties readProperties(String filePath) {
        InputStream in = null;
        try {
            Properties propertie = new Properties();
            in = FileKit.class.getClassLoader().getResourceAsStream(filePath);
            InputStreamReader reader = new InputStreamReader(in, "utf-8");
            propertie.load(reader);
            Properties properties = propertie;
            return properties;
        }
        catch (FileNotFoundException ex) {
            log.info("\u8bfb\u53d6\u5c5e\u6027\u6587\u4ef6--->\u5931\u8d25\uff01- \u539f\u56e0\uff1a\u6587\u4ef6\u8def\u5f84\u9519\u8bef\u6216\u8005\u6587\u4ef6\u4e0d\u5b58\u5728");
            ex.printStackTrace();
        }
        catch (IOException ex) {
            log.info("\u88c5\u8f7d\u6587\u4ef6--->\u5931\u8d25!");
            ex.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static Properties readPropertiesAsStream(String filePath) {
        InputStream in = null;
        try {
            Properties propertie = new Properties();
            in = FileKit.getResourceAsStream(filePath);
            InputStreamReader reader = new InputStreamReader(in, "utf-8");
            propertie.load(reader);
            Properties properties = propertie;
            return properties;
        }
        catch (FileNotFoundException ex) {
            log.info("\u8bfb\u53d6\u5c5e\u6027\u6587\u4ef6--->\u5931\u8d25\uff01- \u539f\u56e0\uff1a\u6587\u4ef6\u8def\u5f84\u9519\u8bef\u6216\u8005\u6587\u4ef6\u4e0d\u5b58\u5728");
            ex.printStackTrace();
        }
        catch (IOException ex) {
            log.info("\u88c5\u8f7d\u6587\u4ef6--->\u5931\u8d25!");
            ex.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static String readPropertiesValue(String fileName, String key) {
        Properties prop = FileKit.readPropertiesAsStream(fileName);
        if (prop != null) {
            return prop.getProperty(key);
        }
        return null;
    }

    public static String readJarPropertiesValue(String classPath, String fileName, String key) {
        Properties prop = FileKit.readJarPropertiesAsStream(classPath, fileName);
        if (prop != null) {
            return prop.getProperty(key);
        }
        return null;
    }

    public static Properties readJarPropertiesAsStream(String classPath, String filePath) {
        InputStream in = null;
        try {
            Properties propertie = new Properties();
            URL url = Thread.currentThread().getContextClassLoader().loadClass(classPath).getClassLoader().getResource(filePath);
            URL url2 = Thread.currentThread().getContextClassLoader().getResource(filePath);
            Class<?> clz = Class.forName(classPath);
            String propertiesPath = jar + clz.getProtectionDomain().getCodeSource().getLocation() + jar_join + filePath;
            URL url3 = new URL(propertiesPath);
            in = url3.openStream();
            InputStreamReader reader = new InputStreamReader(in, "utf-8");
            propertie.load(reader);
            Properties properties = propertie;
            return properties;
        }
        catch (ClassNotFoundException ex) {
            log.info("\u52a0\u8f7d\u6307\u5b9a\u7684classPath--->\u5931\u8d25\uff01 " + classPath);
            ex.printStackTrace();
        }
        catch (FileNotFoundException ex) {
            log.info("\u8bfb\u53d6\u5c5e\u6027\u6587\u4ef6--->\u5931\u8d25\uff01- \u539f\u56e0\uff1a\u6587\u4ef6\u8def\u5f84\u9519\u8bef\u6216\u8005\u6587\u4ef6\u4e0d\u5b58\u5728");
            ex.printStackTrace();
        }
        catch (IOException ex) {
            log.info("\u88c5\u8f7d\u6587\u4ef6--->\u5931\u8d25!");
            ex.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static String readPropertiesValue(Properties prop, String key) {
        if (prop != null) {
            return prop.getProperty(key);
        }
        return null;
    }

    public static InputStream getInputStreamByGet(String url) {
        try {
            HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
            conn.setReadTimeout(5000);
            conn.setConnectTimeout(5000);
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept", "image/gif, image/jpeg, image/pjpeg, image/pjpeg, application/x-shockwave-flash, application/xaml+xml, application/vnd.ms-xpsdocument, application/x-ms-xbap, application/x-ms-application, application/vnd.ms-excel, application/vnd.ms-powerpoint, application/msword, */*");
            conn.setRequestProperty("Accept-Language", "zh-CN");
            conn.setRequestProperty("Charset", "UTF-8");
            if (conn.getResponseCode() == 200) {
                InputStream inputStream = conn.getInputStream();
                return inputStream;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void saveData(InputStream is, File file) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                BufferedInputStream bis = new BufferedInputStream(is);
                try {
                    try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));){
                        byte[] buffer = new byte[1024];
                        int len = -1;
                        while ((len = bis.read(buffer)) != -1) {
                            bos.write(buffer, 0, len);
                            bos.flush();
                        }
                    }
                    if (bis == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (bis == null) throw throwable;
                    bis.close();
                    throw throwable;
                }
                bis.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static ClassLoader getContextClassLoader() {
        ClassLoader classLoader = null;
        if (classLoader == null) {
            try {
                Method method = Thread.class.getMethod("getContextClassLoader", null);
                try {
                    classLoader = (ClassLoader)method.invoke((Object)Thread.currentThread(), null);
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException e) {
                    if (!(e.getTargetException() instanceof SecurityException)) {
                        throw new CoCoException("Unexpected InvocationTargetException", e.getTargetException());
                    }
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (classLoader == null) {
            classLoader = FileKit.class.getClassLoader();
        }
        return classLoader;
    }

    public static InputStream getResourceAsStream(final String name) {
        return (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ClassLoader threadCL = FileKit.getContextClassLoader();
                if (threadCL != null) {
                    return threadCL.getResourceAsStream(name);
                }
                return ClassLoader.getSystemResourceAsStream(name);
            }
        });
    }

    public static byte[] getImageFromNetByUrl(String strUrl) {
        try {
            URL url = new URL(strUrl);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setReadTimeout(5000);
            conn.setConnectTimeout(5000);
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept", "image/gif, image/jpeg, image/pjpeg, image/pjpeg, application/x-shockwave-flash, application/xaml+xml, application/vnd.ms-xpsdocument, application/x-ms-xbap, application/x-ms-application, application/vnd.ms-excel, application/vnd.ms-powerpoint, application/msword, */*");
            conn.setRequestProperty("Accept-Language", "zh-CN");
            conn.setRequestProperty("Charset", "UTF-8");
            if (conn.getResponseCode() == 200) {
                InputStream inStream = conn.getInputStream();
                byte[] btImg = FileKit.readInputStream(inStream);
                return btImg;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static byte[] readInputStream(InputStream inStream) throws Exception {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int len = 0;
        while ((len = inStream.read(buffer)) != -1) {
            outStream.write(buffer, 0, len);
        }
        inStream.close();
        return outStream.toByteArray();
    }
}

