/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.boot.kit.lang;

import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

public class PinYinKit {
    HanyuPinyinOutputFormat format = new HanyuPinyinOutputFormat();

    public PinYinKit() {
        this.format.setCaseType(HanyuPinyinCaseType.UPPERCASE);
        this.format.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
    }

    public String toPinYin(String str) throws BadHanyuPinyinOutputFormatCombination {
        return this.toPinYin(str, "", Type.LOWERCASE);
    }

    public String toPinYin(String str, String spera) throws BadHanyuPinyinOutputFormatCombination {
        return this.toPinYin(str, spera, Type.LOWERCASE);
    }

    public String toPinYin(String str, String spera, Type type) throws BadHanyuPinyinOutputFormatCombination {
        if (str == null || str.trim().length() == 0) {
            return "";
        }
        if (type == Type.UPPERCASE) {
            this.format.setCaseType(HanyuPinyinCaseType.UPPERCASE);
        } else {
            this.format.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        }
        String py = "";
        String temp = "";
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c <= '\u0080') {
                py = String.valueOf(py) + c;
            } else {
                String[] t = PinyinHelper.toHanyuPinyinStringArray((char)c, (HanyuPinyinOutputFormat)this.format);
                if (t == null) {
                    py = String.valueOf(py) + c;
                } else {
                    temp = t[0];
                    if (type == Type.FIRSTUPPER) {
                        temp = String.valueOf(t[0].toUpperCase().charAt(0)) + temp.substring(1);
                    }
                    py = String.valueOf(py) + temp + (i == str.length() - 1 ? "" : spera);
                }
            }
            ++i;
        }
        return py.trim();
    }

    public static void main(String[] args) {
        PinYinKit kit = new PinYinKit();
        try {
            String s = kit.toPinYin("\u6d4b\u8bd5\u4f01\u4e1a123");
            System.out.println(s);
        }
        catch (BadHanyuPinyinOutputFormatCombination e) {
            e.printStackTrace();
        }
    }

    public static enum Type {
        UPPERCASE,
        LOWERCASE,
        FIRSTUPPER;

    }
}

