/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.boot.kit.reflect;

import com.ovopark.boot.kit.lang.StrKit;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ReflectKit {
    protected static Map<Class<?>, Field[]> fieldsCacheMap = new ConcurrentHashMap();
    protected String[] types1 = new String[]{"int", "java.lang.String", "boolean", "char", "float", "double", "long", "short", "byte"};
    protected String[] types2 = new String[]{"Integer", "java.lang.String", "java.lang.Boolean", "java.lang.Character", "java.lang.Float", "java.lang.Double", "java.lang.Long", "java.lang.Short", "java.lang.Byte"};

    public static Object getFieldValue(Object obj, String fieldName) {
        if (obj == null || StrKit.isBlank(fieldName)) {
            return null;
        }
        Field[] fields = ReflectKit.getFields(obj);
        return ReflectKit.getFieldValue(obj, fields, fieldName);
    }

    public static Field[] getFields(Object object) {
        Class<?> cls = object.getClass();
        Field[] fields = fieldsCacheMap.get(cls);
        if (fields != null) {
            return fields;
        }
        fields = object.getClass().getDeclaredFields();
        fieldsCacheMap.put(cls, fields);
        return fields;
    }

    private static Object getFieldValue(Object object, Field[] fields, String fieldName) {
        Field[] fieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            field.setAccessible(true);
            if (field.getName().equals(fieldName)) {
                try {
                    return field.get(object);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        return null;
    }

    public static <T> T clazzToBean(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Field[] getNeedFields(Class<?> clazz) {
        HashMap<String, Field> list = new HashMap<String, Field>();
        while (clazz != null && clazz != Object.class) {
            Field[] fs = clazz.getDeclaredFields();
            int i = 0;
            while (i < fs.length) {
                if (!ReflectKit.isIgnoredField(fs[i]) && !list.containsKey(fs[i].getName())) {
                    list.put(fs[i].getName(), fs[i]);
                }
                ++i;
            }
            clazz = clazz.getSuperclass();
        }
        return list.values().toArray(new Field[list.size()]);
    }

    public static boolean isIgnoredField(Field f) {
        if (Modifier.isStatic(f.getModifiers())) {
            return true;
        }
        return Modifier.isFinal(f.getModifiers());
    }

    public static boolean isBaseType(Object object) {
        Class<?> className = object.getClass();
        return className.equals(Integer.class) || className.equals(Byte.class) || className.equals(Long.class) || className.equals(Double.class) || className.equals(Float.class) || className.equals(Character.class) || className.equals(Short.class) || className.equals(Boolean.class);
    }

    public static boolean isLangType(Object object) {
        Class<?> className = object.getClass();
        return className.equals(String.class) || className.equals(Integer.class) || className.equals(Byte.class) || className.equals(Long.class) || className.equals(Double.class) || className.equals(Float.class) || className.equals(Character.class) || className.equals(Short.class) || className.equals(Boolean.class);
    }
}

