package com.ovopark.boot.kit.bean;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.DecimalFormat;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.ovopark.boot.kit.json.JacksonKit;

/**
 * 
    * @ClassName: BeanCopyKit
    * @Description: TODO(BeanCopy工具)
    * @author Remiel_Mercy xuefei_fly@126.com
    * @date  2018年12月20日 下午9:57:23 
    *
 */
public class BeanCopyKit {
	protected static final Logger log = LoggerFactory.getLogger(BeanCopyKit.class);
	
	/**
	 * 
	    * @Title: getProperty
	    * @Description: TODO(获取bean某个属性的值)
	    * @param @param bean
	    * @param @param propertyName
	    * @param @return    参数
	    * @return Object    返回类型
	    * @throws
	 */
    @SuppressWarnings({ "rawtypes", "unchecked" })
	private static Object getProperty(Object bean, String propertyName) {
        Class clazz = bean.getClass();
        try {
            Field field = clazz.getDeclaredField(propertyName);
            Method method = clazz.getDeclaredMethod(getGetterName(field.getName(),field.getType()), new Class[]{});
            return method.invoke(bean, new Object[]{});
        } catch (Exception e) {
        }
        return null;
    }
	
	/**
	    * @Title: getGetterName
	    * @Description: TODO( 根据变量名得到get方法)
	    * @param @param propertyName
	    * @param @return    参数
	    * @return String    返回类型
	    * @throws
	 */
	@SuppressWarnings("unused")
	private static String getGetterName(String propertyName) {
        String method ;
        if( propertyName.length()>1&& Character.isUpperCase(propertyName.charAt(1))){
             method = "get" +propertyName;
        }else{
            method = "get" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        }
        return method;
    }
	/**
	 * 
	    * @Title: getGetterName
	    * @Description: TODO(根据变量名和类型获取getter方法)
	    * @param @param propertyName
	    * @param @param type
	    * @param @return    参数
	    * @return String    返回类型
	    * @throws
	 */
	 private static String getGetterName(String propertyName, Class<?> type) {
	        String method ;
	        if(type==Boolean.class|| type==boolean.class){
	            if("is".equalsIgnoreCase(propertyName.substring(0, 2))){
	                return propertyName;
	            }else{
	                return "is" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
	            }

	        }
	        if( propertyName.length()>1&& Character.isUpperCase(propertyName.charAt(1))){
	            method = "get" +propertyName;
	        }else{
	            method = "get" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
	        }
	        return method;
	    }

	/**
	 * 
	    * @Title: getSourPropertyValue
	    * @Description: TODO(根据属性名获取的值)
	    * @param @param sourceBean
	    * @param @param sourcePropertyName
	    * @param @return    参数
	    * @return Object    返回类型
	    * @throws
	 */
    @SuppressWarnings({ "rawtypes", "unchecked" })
	private static Object getSourPropertyValue(Object sourceBean, String sourcePropertyName) {
        Class clazz = sourceBean.getClass();
        try {
            Field field = clazz.getDeclaredField(sourcePropertyName);
            Method method = clazz.getDeclaredMethod(getGetterName(field.getName(),field.getType()), new Class[]{});
            return method.invoke(sourceBean, new Object[]{});
        } catch (Exception e) {
            log.error("获取属性名（不区分大小写）相似的值赋值出差", e);
        }
        return null;
    }
    /**
     * 
        * @Title: getSetterName
        * @Description: TODO(得到setter方法)
        * @param @param propertyName
        * @param @return    参数
        * @return String    返回类型
        * @throws
     */
    private static String getSetterName(String propertyName) {
        String method ;
        if( propertyName.length()>1&& Character.isUpperCase(propertyName.charAt(1))){
            method = "set" +propertyName;
        }else{
            method = "set" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        }
        return method;
    }
    /**
     * 
        * @Title: setObjPropertyBySourceProperty
        * @Description: TODO(给目标bean赋值)
        * @param @param objBean
        * @param @param sourcePropertyName
        * @param @param value
        * @param @return    参数
        * @return Object    返回类型
        * @throws
     */
    @SuppressWarnings({ "rawtypes", "unused", "unchecked" })
	private static Object setObjPropertyBySourceProperty(Object objBean, String sourcePropertyName, Object value) {
        Class clazz = objBean.getClass();
        Field[] fields = clazz.getDeclaredFields();
        try {
            for (int i = 0, j = fields.length; i < j; i++) {
                String propertyName = fields[i].getName();
                if (sourcePropertyName.equalsIgnoreCase(propertyName)) {
                    Field field = clazz.getDeclaredField(propertyName);
                    if (field.getType() == BigDecimal.class) {
                        if (value instanceof String) {
                            value = new BigDecimal(String.valueOf(value));
                        } else if (value instanceof Integer || value instanceof Double) {
                            value = BigDecimal.valueOf(Double.parseDouble(String.valueOf(value)));
                        }
                    }
                    if (field.getType() == Double.class || field.getType() == double.class) {
                        if (value instanceof BigDecimal) {
                            DecimalFormat df = new DecimalFormat("#.000000");
                            Double v = Double.parseDouble(String.valueOf(value));
                            value = df.format(v);
                        }
                    }

                    Method method = clazz.getDeclaredMethod(getSetterName(field.getName()), new Class[]{field.getType()});
                    return method.invoke(objBean, new Object[]{value});
                }
            }

        } catch (Exception e) {
        }
        return null;
    }
    /**
     * 
        * @Title: setObjProperty
        * @Description: TODO(给目标bean赋值)
        * @param @param objBean
        * @param @param propertyName
        * @param @param value
        * @param @return    参数
        * @return Object    返回类型
        * @throws
     */
    @SuppressWarnings({ "rawtypes", "unchecked" })
	private static Object setObjProperty(Object objBean, String propertyName, Object value) {
        Class clazz = objBean.getClass();
        try {
            Field field = clazz.getDeclaredField(propertyName);
            if (field.getType() == BigDecimal.class) {
                if (value instanceof String) {
                    value = new BigDecimal(String.valueOf(value));
                } else if (value instanceof Integer || value instanceof Double) {
//                          传double直接new BigDecimal，数会变大
                    value = BigDecimal.valueOf(Double.parseDouble(String.valueOf(value)));
                }
            }
            if (field.getType() == Double.class || field.getType() == double.class) {
                if (value instanceof BigDecimal) {
                    DecimalFormat df = new DecimalFormat("#.000000");
                    Double v = Double.parseDouble(String.valueOf(value));
                    value =new BigDecimal(df.format(v));
                }
            }
            if (field.getType() == Integer.class || field.getType() == int.class) {
                if (value instanceof Float) {
                     value = Math.round(Float.parseFloat(String.valueOf(value)));
                }
            }
            Method method = clazz.getDeclaredMethod(getSetterName(field.getName()), new Class[]{field.getType()});
            log.info("给目标bean赋值,propertyName:{},value:{}",propertyName,value);
            Object obj = method.invoke(objBean, new Object[]{value});
            return obj;

        } catch (Exception e) {
            log.error("给目标bean赋值出错,propertyName:{},value:{}",propertyName,value,e);
        }
        return null;
    }
	public static Object copyByIgnoreCase(Object obj, Object source, boolean isCover) {
		 try {
	            Field[] objFields = obj.getClass().getDeclaredFields();
	            Field[] sourFields = source.getClass().getDeclaredFields();
	            for (int i = 0; i < sourFields.length; i++) {
	                String sourcePropertyName = sourFields[i].getName();
	                //获取来源对象的属性值
	                Object propertyValue = getSourPropertyValue(source, sourcePropertyName);
	                for (int j = 0; j < objFields.length; j++) {
	                    try {
	                        String objPropertyName = objFields[j].getName();
	                        if (objPropertyName.equalsIgnoreCase(sourcePropertyName)) {
	                            if (isCover) {
	                                if (getProperty(obj, objPropertyName) == null && propertyValue != null) {
	                                    setObjProperty(obj, objPropertyName, propertyValue);
	                                }
	                            } else {
	                                setObjProperty(obj, objPropertyName, propertyValue);
	                            }
	                            break;
	                        }
	                    } catch (Exception e) {
	                        log.error("给目标bean赋值出错,objPropertyName:{},value:{}",sourcePropertyName,propertyValue,e);
	                        e.printStackTrace();
	                    }
	                }

	            }
	        } catch (SecurityException e) {
	            e.printStackTrace();
	            log.error("给目标bean赋值出错,obje:{},sour:{}", JacksonKit.toJSon(obj), JacksonKit.toJSon(source),e);
	        }
	        return obj;
	}
}
