package com.ovopark.boot.kit.collection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * 
 * @ClassName: TreeKit
 * @Description: TODO(树型结构工具类)
 * @author Remiel_Mercy xuefei_fly@126.com
 * @date 2017年8月18日 上午10:42:34
 */
public class TreeKit {
	/**
	 * 将List 数组转换为Tree 所需要的数据(循环方式)
	 * 
	 * @param list
	 * @param id
	 *            ID 列
	 * @param pid
	 *            PID 列
	 * @return
	 */
	@SuppressWarnings("unchecked")
	public static List<Map<String,Object>> ArrayToTreeData(List<Map<String,Object>> mydata, String id, String pid) {
		Map<Object, Object> h = new HashMap<Object, Object>();// 数据索引
		List<Map<String,Object>> r = new ArrayList<Map<String,Object>>();// 数据池，返回的数据

		for (Map<String,Object> item : mydata) {
			if (!item.containsKey(id)) {
				continue;
			} else {
				h.put(item.get(id), item);
			}
		}
		for (Map<String,Object> item : mydata) {
			if (!item.containsKey(id)) {
				continue;
			}
			if (!item.containsKey(pid) || (item.get(pid) == null) || !h.containsKey(item.get(pid))) {
				r.add(item);
			} else {
				Map<String, List<Map<String,Object>>> pitem = (Map<String, List<Map<String,Object>>>) h.get(item.get(pid));
				if (!pitem.containsKey("children")) {
					List<Map<String,Object>> children = new ArrayList<Map<String,Object>>();
					children.add(item);
					pitem.put("children", children);
				} else {
					List<Map<String,Object>> children = pitem.get("children");
					children.add(item);
					pitem.put("children", children);
				}
			}
		}
		return r;
	}

}
