package com.ovopark.boot.kit.hardware;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Scanner;
import java.util.stream.Collectors;

import com.ovopark.boot.kit.http.IPKit;
import com.ovopark.boot.kit.lang.StrKit;

/**
 * @ClassName: ServerKit
 * @Description:TODO(服务器相关工具类)
 * @author: Remiel_Mercy
 * @date: 2019年11月7日 上午10:32:20
 * 
 * @Copyright: 2019 www.ovopark.com Inc. All rights reserved.
 */
public class ServerKit {
	/**
	 * 
	 * @Title: getIpAddress   
	 * @Description: TODO( 获取IP地址)   
	 * @param: @return      
	 * @return: List<String>      
	 * @throws
	 */
	public static List<String> getIpAddress() {
		// 1. 获取所有网络接口
		List<InetAddress> inetAddresses = getAllInetAddress();
		// 2. 获取所有网络接口的Ip地址
		List<String>result = inetAddresses.stream().map(InetAddress::getHostAddress).distinct().map(String::toLowerCase).collect(Collectors.toList());
		return result;
	}
	/**
	 * 
	 * @Title: getMacAddress   
	 * @Description: TODO(获取mac地址)   
	 * @param: @return      
	 * @return: List<String>      
	 * @throws
	 */
	public static List<String> getMacAddress() {
		// 1. 获取所有网络接口
		List<InetAddress> inetAddresses = getAllInetAddress();
		// 2. 获取所有网络接口的Mac地址
		List<String>result = inetAddresses.stream().map(inetAddr -> getMacByInetAddress(inetAddr)).distinct()
				.collect(Collectors.toList());

		return result;
	}
	/**
	 * @Title: getCpuSerial   
	 * @Description: TODO(获取CPU 序列号)   
	 * @param: @return      
	 * @return: String      
	 * @throws
	 */
	public static String getCpuSerial(){
		return IPKit.isWindowsOS()? getCPUSerialWin():getCPUSerialLinux();
	}
	
	/**
	 * @Title: getMainBoardSerial   
	 * @Description: TODO(获取主板序列号)   
	 * @param: @return      
	 * @return: String      
	 * @throws
	 */
	public static String getMainBoardSerial(){
		return IPKit.isWindowsOS()? getMainBoardSerialWin():getMainBoardSerialLinux();
	}
	
	/**
	 * 
	 * @Title: getAllInetAddress   
	 * @Description: TODO(获取当前服务器所有符合条件的InetAddress)   
	 * @param: @return      
	 * @return: List<InetAddress>      
	 * @throws
	 */
	private static List<InetAddress> getAllInetAddress() {
		List<InetAddress> result = new ArrayList<InetAddress>();
		try {
			Enumeration<NetworkInterface> netInterfaces = (Enumeration<NetworkInterface>) NetworkInterface
					.getNetworkInterfaces();
			while (netInterfaces.hasMoreElements()) {
				NetworkInterface iface = (NetworkInterface) netInterfaces.nextElement();
				// 在所有的接口下再遍历IP
				for (Enumeration<InetAddress> inetAddresses = iface.getInetAddresses(); inetAddresses
						.hasMoreElements();) {
					InetAddress inetAddr = (InetAddress) inetAddresses.nextElement();
				     //排除LoopbackAddress、LinkLocalAddress、MulticastAddress类型的IP地址
	                if(!inetAddr.isLoopbackAddress()&& !inetAddr.isLinkLocalAddress() && !inetAddr.isMulticastAddress()){
	                    result.add(inetAddr);
	                }
				}
			}
		} catch (SocketException e) {
			e.printStackTrace();
		}
		return result;
	}

	/**
	 * 
	 * @Title: getMacByInetAddress   
	 * @Description: TODO(获取某个网络接口的Mac地址)   
	 * @param: @param inetAddr
	 * @param: @return      
	 * @return: String      
	 * @throws
	 */
	private static String getMacByInetAddress(InetAddress inetAddr) {
		try {
			byte[] mac = NetworkInterface.getByInetAddress(inetAddr).getHardwareAddress();
			StringBuffer stringBuffer = new StringBuffer();

			for (int i = 0; i < mac.length; i++) {
				if (i != 0) {
					stringBuffer.append("-");
				}

				// 将十六进制byte转化为字符串
				String temp = Integer.toHexString(mac[i] & 0xff);
				if (temp.length() == 1) {
					stringBuffer.append("0" + temp);
				} else {
					stringBuffer.append(temp);
				}
			}

			return stringBuffer.toString().toUpperCase();
		} catch (SocketException e) {
			e.printStackTrace();
		}

		return null;
	}
    private static String getCPUSerialWin() {
		try {
			// 序列号
			String serialNumber = "";
			// 使用WMIC获取CPU序列号
			Process process = Runtime.getRuntime().exec("wmic cpu get processorid");
			process.getOutputStream().close();
			Scanner scanner = new Scanner(process.getInputStream());
			if (scanner != null && scanner.hasNext()) {
				scanner.next();
			}
			if (scanner.hasNext()) {
				serialNumber = scanner.next().trim();
			}
			scanner.close();
			return serialNumber;
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return null;
    }
    
    private static String getCPUSerialLinux(){
		try {
			// 序列号
			String serialNumber = "";
			// 使用dmidecode命令获取CPU序列号
			String[] shell = { "/bin/bash", "-c","dmidecode -t processor | grep 'ID' | awk -F ':' '{print $2}' | head -n 1" };
			Process process = Runtime.getRuntime().exec(shell);
			process.getOutputStream().close();
			BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
			String line = reader.readLine().trim();
			if (!StrKit.isBlank(line)) {
				serialNumber = line;
			}
			reader.close();
			return serialNumber;
		} catch (IOException e) {
			e.printStackTrace();
		}
		return null;
    }
    
    private static String getMainBoardSerialWin(){
		try {
			// 序列号
			String serialNumber = "";
			// 使用WMIC获取主板序列号
			Process process = Runtime.getRuntime().exec("wmic baseboard get serialnumber");
			process.getOutputStream().close();
			Scanner scanner = new Scanner(process.getInputStream());

			if (scanner.hasNext()) {
				scanner.next();
			}

			if (scanner.hasNext()) {
				serialNumber = scanner.next().trim();
			}

			scanner.close();
			return serialNumber;
		} catch (IOException e) {
			e.printStackTrace();
		}
		return null;
    }
    
    
    private static String getMainBoardSerialLinux(){
		try {
			// 序列号
			String serialNumber = "";
			// 使用dmidecode命令获取主板序列号
			String[] shell = { "/bin/bash", "-c","dmidecode | grep 'Serial Number' | awk -F ':' '{print $2}' | head -n 1" };
			Process process = Runtime.getRuntime().exec(shell);
			process.getOutputStream().close();
			BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));

			String line = reader.readLine().trim();
			if (!StrKit.isBlank(line)) {
				serialNumber = line;
			}

			reader.close();
			return serialNumber;
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return null;
    }
    
	public static void main(String[] args) {
		System.out.println(ServerKit.getIpAddress());
		System.out.println(ServerKit.getMacAddress());
		System.out.println(ServerKit.getCpuSerial());
		System.out.println(ServerKit.getMainBoardSerial());
	}
}
