package com.ovopark.boot.kit.http;

import java.net.MalformedURLException;
import java.net.URL;

import com.ovopark.boot.common.entity.bo.UrlBo;
/**
 * @ClassName:  UrlKit   
 * @Description:TODO(Url 工具类)   
 * @author: Remiel_Mercy 
 * @date:   2020年12月30日 下午6:44:49   
 *     
 * @Copyright: 2020 www.ovopark.com Inc. All rights reserved.
 */
public class UrlKit {

	
	public static final int HTTP_80=80;
	

	
	/**
	 * @Title: getUrlBo   
	 * @Description: TODO(获取Url对象)   
	 * @param: @param url
	 * @param: @return      
	 * @return: UrlBo      
	 * @throws
	 */
	public static UrlBo getUrlBo(String url) {
		return getUrlBo(url,false);
	}
	
	public static UrlBo getUrlBo(String url,Boolean dnsToIp) {
		try {
			URL u = new URL(url);
			UrlBo bo=new UrlBo();
			bo.setProtocol(u.getProtocol());// 协议
			String host=u.getHost();
			if(dnsToIp&&!IPKit.isIPV4(host)) {
				host=IPKit.dnsToIp(host);
			}
			bo.setHost(host);//主机
			bo.setPort(u.getPort()==-1?HTTP_80:u.getPort());//端口
			return bo;
		} catch (MalformedURLException e) {
			e.printStackTrace();
		}
		return null;
	}
}
