package com.ovopark.boot.kit.id.snowflake;



/**
 * ID相关工具类
 *
 */
public class IdUtil {

  public static final String PROPERTIES_DATABASE = "database";
  /**
   * DB主键相关，同一个项目服务部署多个时的worker编号，编号范围：0-31
   * 同一个服务部署多个时，也就是key.service.code都相同时，请注意保证key.worker.code不同。
   * 否则，高并发时可能引起主键冲突
   */
  public static final String KEY_WORKER_CODE = "key.worker.code";
  /**
   * DB主键相关，项目服务的编号，编号范围：0-31
   */
  public static final String KEY_SERVICE_CODE = "key.service.code";

  public static String generateId(long workerId, long datacenterId) {
	SnowflakeIdWorker idWorker = new SnowflakeIdWorker(workerId, datacenterId);
    return String.valueOf(idWorker.nextId());
  }
}
