package com.ovopark.boot.kit.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

import com.ovopark.boot.exception.CoCoException;


/**
    * @ClassName: FileKit
    * @Description: TODO(文件工具类)
    * @author Remiel_Mercy xuefei_fly@126.com
    * @date 2017年8月13日 下午4:15:11
 */
public class FileKit {
	protected static final Logger log = LoggerFactory.getLogger(FileKit.class);
	
	private static final String jar_join="!/";
	private static final String jar="jar:";
	/**
	 * 
	    * @Title: readProperties
	    * @Description: TODO(加载指定的Properties文件)
	    * @param @param filePath
	    * @param @return    参数
	    * @return Properties    返回类型
	    * @throws
	 */
	  public static Properties readProperties(String filePath){  
		  InputStream in =null;
			try {
				Properties propertie = new Properties();
				in = FileKit.class.getClassLoader().getResourceAsStream(filePath);
				InputStreamReader reader = new InputStreamReader(in,"utf-8"); 
				propertie.load(reader);
	            return propertie;  
			} catch (FileNotFoundException ex) {
				log.info("读取属性文件--->失败！- 原因：文件路径错误或者文件不存在");
				ex.printStackTrace();
			} catch (IOException ex) {
				log.info("装载文件--->失败!");
				ex.printStackTrace();
			}finally{  
	            try {  
	                if(in != null){  
	                    in.close();  
	                }  
	            } catch (IOException e) {  
	                e.printStackTrace();  
	            }  
	        }  
	        return null;
	  }
	  public static Properties readPropertiesAsStream(String filePath){  
		  InputStream in =null;
			try {
				Properties propertie = new Properties();
				in =getResourceAsStream(filePath);
				InputStreamReader reader = new InputStreamReader(in,"utf-8"); 
				propertie.load(reader);
	            return propertie;  
			} catch (FileNotFoundException ex) {
				log.info("读取属性文件--->失败！- 原因：文件路径错误或者文件不存在");
				ex.printStackTrace();
			} catch (IOException ex) {
				log.info("装载文件--->失败!");
				ex.printStackTrace();
			}finally{  
	            try {  
	                if(in != null){  
	                    in.close();  
	                }  
	            } catch (IOException e) {  
	                e.printStackTrace();  
	            }  
	        }  
	        return null;
	  }
	  /**
	   * 
	      * @Title: readPropertiesValue
	      * @Description: TODO(根据文件名和键名获取值 )
	      * @param @param fileName
	      * @param @param key
	      * @param @return    参数
	      * @return String    返回类型
	      * @throws
	   */
	  public static String readPropertiesValue(String fileName, String key){  
	        Properties prop = readPropertiesAsStream(fileName);  
	        if(prop != null){  
	            return prop.getProperty(key);  
	        }  
	        return null;  
	  }
	  
	  public static String readJarPropertiesValue(String classPath,String fileName, String key){  
	        Properties prop = readJarPropertiesAsStream(classPath,fileName);  
	        if(prop != null){  
	            return prop.getProperty(key);  
	        }  
	        return null;  
	  } 
	  
	  public static Properties readJarPropertiesAsStream(String classPath,String filePath){
		  InputStream in =null;
			try {
				Properties propertie = new Properties();
				URL url = Thread.currentThread().getContextClassLoader().loadClass(classPath).getClassLoader().getResource(filePath);
				URL url2 = Thread.currentThread().getContextClassLoader().getResource(filePath);
				Class clz=Class.forName(classPath);
				String propertiesPath=jar+clz.getProtectionDomain().getCodeSource().getLocation()+jar_join+filePath;
				URL url3 = new URL(propertiesPath);
				in =url3.openStream();
				InputStreamReader reader = new InputStreamReader(in,"utf-8"); 
				propertie.load(reader);
	            return propertie; 
			}catch (ClassNotFoundException ex) {
				log.info("加载指定的classPath--->失败！ "+classPath);
				ex.printStackTrace();
			} catch (FileNotFoundException ex) {
				log.info("读取属性文件--->失败！- 原因：文件路径错误或者文件不存在");
				ex.printStackTrace();
			} catch (IOException ex) {
				log.info("装载文件--->失败!");
				ex.printStackTrace();
			}finally{  
	            try {  
	                if(in != null){  
	                    in.close();  
	                }  
	            } catch (IOException e) {  
	                e.printStackTrace();  
	            }  
	        }  
	        return null;
	  }
	  /**
	      * @Title: readPropertiesValue
	      * @Description: TODO(根据键名获取值 )
	      * @param @param prop
	      * @param @param key
	      * @param @return    参数
	      * @return String    返回类型
	      * @throws
	   */
	    public static String readPropertiesValue(Properties prop, String key){  
	        if(prop != null){  
	            return prop.getProperty(key);  
	        }  
	        return null;  
	    } 
	    /**
	        * @Title: getInputStreamByGet
	        * @Description: TODO(Http url 文件地址转换成字节流)
	        * @param @param url
	        * @param @return    参数
	        * @return InputStream    返回类型
	        * @throws
	     */
	    public static InputStream getInputStreamByGet(String url) {
	        try {
	            HttpURLConnection conn = (HttpURLConnection) new URL(url)
	                    .openConnection();
	            conn.setReadTimeout(5000);
	            conn.setConnectTimeout(5000);
	            conn.setRequestMethod("GET");
	            conn.setRequestProperty(  
	                    "Accept", "image/gif, image/jpeg, image/pjpeg, image/pjpeg, "  
	                    + "application/x-shockwave-flash, application/xaml+xml, "  
	                    + "application/vnd.ms-xpsdocument, application/x-ms-xbap, "  
	                    + "application/x-ms-application, application/vnd.ms-excel, "  
	                    + "application/vnd.ms-powerpoint, application/msword, */*");  
	            conn.setRequestProperty("Accept-Language", "zh-CN");  
	            conn.setRequestProperty("Charset", "UTF-8");  
	            if (conn.getResponseCode() == HttpURLConnection.HTTP_OK) {
	                InputStream inputStream = conn.getInputStream();
	                return inputStream;
	            }

	        } catch (IOException e) {
	            e.printStackTrace();
	        }
	        return null;
	    }
	    /**
	        * @Title: saveData
	        * @Description: TODO(保存文件只本地)
	        * @param @param is
	        * @param @param file    参数
	        * @return void    返回类型
	        * @throws
	     */
	    public static void saveData(InputStream is, File file) {
	        try (BufferedInputStream bis = new BufferedInputStream(is);
	                BufferedOutputStream bos = new BufferedOutputStream(
	                        new FileOutputStream(file));) {
	            byte[] buffer = new byte[1024];
	            int len = -1;
	            while ((len = bis.read(buffer)) != -1) {
	                bos.write(buffer, 0, len);
	                bos.flush();
	            }
	        } catch (IOException e) {
	            e.printStackTrace();
	        }
	    }
	    
	    private static ClassLoader getContextClassLoader()
	    {
	        ClassLoader classLoader = null;

	        if (classLoader == null) {
	            try {
	                // Are we running on a JDK 1.2 or later system?
	                Method method = Thread.class.getMethod("getContextClassLoader", null);
	                // Get the thread context class loader (if there is one)
	                try {
	                    classLoader = (ClassLoader)method.invoke(Thread.currentThread(), null);
	                } catch (IllegalAccessException e) {
	                    ;  // ignore
	                } catch (InvocationTargetException e) {
	                    if (e.getTargetException() instanceof SecurityException) {
	                        ;  // ignore
	                    } else {
	                        throw new CoCoException("Unexpected InvocationTargetException", e.getTargetException());
	                    }
	                }
	            } catch (NoSuchMethodException e) {
	                ;  // ignore
	            }
	        }

	        if (classLoader == null) {
	            classLoader = FileKit.class.getClassLoader();
	        }
	        return classLoader;
	    }
	    @SuppressWarnings({ "unchecked", "rawtypes" })
		public static InputStream getResourceAsStream(final String name){
	    	 return (InputStream)AccessController.doPrivileged(
	    	            new PrivilegedAction() {
	    	                public Object run() {
	    	                    ClassLoader threadCL = getContextClassLoader();
	    	                    if (threadCL != null) {
	    	                        return threadCL.getResourceAsStream(name);
	    	                    } else {
	    	                        return ClassLoader.getSystemResourceAsStream(name);
	    	                    }
	    	                }
	    	            });
	    }
	    
	    /**  
	     * 根据地址获得数据的字节流  
	     * @param strUrl 网络连接地址  
	     * @return  
	     */    
	    public static byte[] getImageFromNetByUrl(String strUrl){    
	        try {    
	            URL url = new URL(strUrl);    
	            HttpURLConnection conn = (HttpURLConnection)url.openConnection();    
	            conn.setReadTimeout(5000);
	            conn.setConnectTimeout(5000);
	            conn.setRequestMethod("GET");
	            conn.setRequestProperty(  
	                    "Accept", "image/gif, image/jpeg, image/pjpeg, image/pjpeg, "  
	                    + "application/x-shockwave-flash, application/xaml+xml, "  
	                    + "application/vnd.ms-xpsdocument, application/x-ms-xbap, "  
	                    + "application/x-ms-application, application/vnd.ms-excel, "  
	                    + "application/vnd.ms-powerpoint, application/msword, */*");  
	            conn.setRequestProperty("Accept-Language", "zh-CN");  
	            conn.setRequestProperty("Charset", "UTF-8");    
	            if (conn.getResponseCode() == HttpURLConnection.HTTP_OK) {
	                InputStream inStream = conn.getInputStream();//通过输入流获取图片数据    
	                byte[] btImg = readInputStream(inStream);//得到图片的二进制数据    
	                return btImg;    
	            }
	        } catch (Exception e) {    
	            e.printStackTrace();    
	        }    
	        return null;    
	    }    
	    /**  
	     * 从输入流中获取数据  
	     * @param inStream 输入流  
	     * @return  
	     * @throws Exception  
	     */    
	    public static byte[] readInputStream(InputStream inStream) throws Exception{    
	        ByteArrayOutputStream outStream = new ByteArrayOutputStream();    
	        byte[] buffer = new byte[1024];    
	        int len = 0;    
	        while( (len=inStream.read(buffer)) != -1 ){    
	            outStream.write(buffer, 0, len);    
	        }    
	        inStream.close();    
	        return outStream.toByteArray();    
	    } 
	    
	    /**
	     * @Title: MultipartFileToFile   
	     * @Description: TODO(将MultipartFile转换为File)   
	     * @param: @param multiFile
	     * @param: @return      
	     * @return: File      
	     * @throws
	     */
	    public static File MultipartFileToFile(MultipartFile multiFile) {
	    	String fileName = multiFile.getOriginalFilename();
	    	String prefix = fileName.substring(fileName.lastIndexOf("."));
	    	try {
	    		File file = File.createTempFile(fileName, prefix);
	    		multiFile.transferTo(file);
	    		return file;
	    	} catch (Exception e) {
	    		e.printStackTrace();
	    	}
	    	return null;
	    }
}
