package com.ovopark.boot.kit.json;

import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser.Feature;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.ovopark.boot.kit.lang.StrKit;

public class Jackson2Kit {
	private static ObjectMapper objectMapper = new ObjectMapper();
	static {
		objectMapper.configure(Feature.ALLOW_COMMENTS, true);
		objectMapper.configure(Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
		objectMapper.configure(Feature.ALLOW_SINGLE_QUOTES, true);
		objectMapper.configure(Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
		objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, true);
		objectMapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
		objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
		// 解决jackson2无法反序列化LocalDateTime的问题
		objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
		objectMapper.registerModule(new JavaTimeModule());
		
		objectMapper.getSerializerProvider().setNullValueSerializer(new JsonSerializer<Object>() {
			@Override
			public void serialize(Object o, JsonGenerator jsonGenerator, SerializerProvider serializerProvider)
					throws IOException {
				jsonGenerator.writeString("");
			}
		});
	}

	public static <T> String objToJson(T obj) {
		if (obj == null) {
			return null;
		}
		try {
			return obj instanceof String ? (String) obj : objectMapper.writeValueAsString(obj);
		} catch (Exception e) {
			return null;
		}
	}

	public static <T> String objToJsonPretty(T obj) {
		if (obj == null) {
			return null;
		}
		try {
			return obj instanceof String ? (String) obj
					: objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(obj);
		} catch (Exception e) {
			return null;
		}
	}

	@SuppressWarnings("unchecked")
	public static <T> T json2Object(String json, Class<T> clazz) {
		if (StrKit.isEmpty(json) || clazz == null) {
			return null;
		}
		try {
			return clazz.equals(String.class) ? (T) json : objectMapper.readValue(json, clazz);
		} catch (Exception e) {
			return null;
		}
	}

	/**
	 * 
	 * @Title: json2Object @Description: TODO(多泛型的转换) @param: @param
	 * json @param: @param typeReference @param: @return @return: T @throws
	 */
	@SuppressWarnings("unchecked")
	public static <T> T json2Object(String json, TypeReference<?> typeReference) {
		if (StrKit.isEmpty(json) || typeReference == null) {
			return null;
		}
		try {
			return (T) (typeReference.getType().equals(String.class) ? json
					: objectMapper.readValue(json, typeReference));
		} catch (Exception e) {
			return null;
		}
	}

	public static <T> T json2Object(String json, Class<?> collectionClazz, Class<?>... elements) {
		JavaType javaType = objectMapper.getTypeFactory().constructParametricType(collectionClazz, elements);
		try {
			return objectMapper.readValue(json, javaType);
		} catch (Exception e) {
			return null;
		}
	}
	public static <T> T treeToValue(JsonNode jsonNode, Class<T> clazz) {
		try {
			return objectMapper.treeToValue(jsonNode, clazz);
		} catch (Exception e) {
			return null;
		}
	}
	
	 public static JsonNode getJsonNode(String jsonStr) {
		try {
			return objectMapper.readTree(jsonStr);
		} catch (IOException e) {
			e.printStackTrace();
			return null;
		}
	}

	
	
	public static <T> T json2Object(String json, JavaType valueType) {
		try {
			return objectMapper.readValue(json,valueType);
		} catch (Exception e) {
			return null;
		}
	}

	
	public static JavaType getJavaType(Type type) {
        //判断是否带有泛型
        if (type instanceof ParameterizedType) {
            Type[] actualTypeArguments = ((ParameterizedType) type).getActualTypeArguments();
            //获取泛型类型
            Class rowClass = (Class) ((ParameterizedType) type).getRawType();
            JavaType[] javaTypes = new JavaType[actualTypeArguments.length];
            for (int i = 0; i < actualTypeArguments.length; i++) {
                //泛型也可能带有泛型，递归获取
                javaTypes[i] = getJavaType(actualTypeArguments[i]);
            }
            return TypeFactory.defaultInstance().constructParametricType(rowClass, javaTypes);
        } else {
            //简单类型直接用该类构建JavaType
            Class cla = (Class) type;
            return TypeFactory.defaultInstance().constructParametricType(cla, new JavaType[0]);
        }
    }
	
}
