package com.ovopark.boot.kit.json.serializer;

import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;

/**
 * 
    * @ClassName: CoCoJsonLocalDateTimeDeserializers
    * @Description: TODO(Json时间转换器)
    * @author Remiel_Mercy xuefei_fly@126.com
    * @date  2019年1月2日 下午5:52:07 
    *
 */
public class CoCoJsonLocalDateTimeDeserializer extends JsonDeserializer<LocalDateTime>{

	@Override
	public LocalDateTime deserialize(JsonParser p, DeserializationContext ctxt)
			throws IOException, JsonProcessingException {
	    DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
	    LocalDateTime ldt = LocalDateTime.parse(p.getText(),df);
	    return ldt;
	}

}
