package com.ovopark.boot.kit.lang;

import java.util.List;

/**
 * 
 * @ClassName: StrKit
 * @Description: TODO(字符串工具类)
 * @author Remiel_Mercy xuefei_fly@126.com
 * @date 2017年8月3日 上午11:06:57
 */
public class StrKit {
	public static final char C_SPACE = ' ';
	public static final char C_TAB = '	';
	public static final char C_DOT = '.';
	public static final char C_SLASH = '/';
	public static final char C_BACKSLASH = '\\';
	public static final char C_CR = '\r';
	public static final char C_LF = '\n';
	public static final char C_UNDERLINE = '_';
	public static final char C_COMMA = ',';
	public static final char C_DELIM_START = '{';
	public static final char C_DELIM_END = '}';

	public static final String SPACE = " ";
	public static final String TAB = "	";
	public static final String DOT = ".";
	public static final String SLASH = "/";
	public static final String BACKSLASH = "\\";
	public static final String EMPTY = "";
	public static final String CR = "\r";
	public static final String LF = "\n";
	public static final String CRLF = "\r\n";
	public static final String UNDERLINE = "_";
	public static final String COMMA = ",";

	public static final String HTML_NBSP = "&nbsp;";
	public static final String HTML_AMP = "&amp";
	public static final String HTML_QUOTE = "&quot;";
	public static final String HTML_LT = "&lt;";
	public static final String HTML_GT = "&gt;";

	public static final String EMPTY_JSON = "{}";
	public static final int INDEX_NOT_FOUND = -1;

	/**
	 * 
	 * 首字母变小写
	 * 
	 */
	public static String firstCharToLowerCase(String str) {
		char firstChar = str.charAt(0);
		if (firstChar >= 'A' && firstChar <= 'Z') {
			char[] arr = str.toCharArray();
			arr[0] += ('a' - 'A');
			return new String(arr);
		}
		return str;
	}

	/**
	 * 
	 * 首字母变大写
	 * 
	 */
	public static String firstCharToUpperCase(String str) {
		char firstChar = str.charAt(0);
		if (firstChar >= 'a' && firstChar <= 'z') {
			char[] arr = str.toCharArray();
			arr[0] -= ('a' - 'A');
			return new String(arr);
		}
		return str;
	}

	/**
	 * 
	 * 字符串为 null 或者内部字符全部为 ' ' '\t' '\n' '\r' 这四类字符时返回 true
	 * 
	 */
	public static boolean isBlank(String str) {
		if (str == null) {
			return true;
		}
		int len = str.length();
		if (len == 0) {
			return true;
		}
		for (int i = 0; i < len; i++) {
			switch (str.charAt(i)) {
			case ' ':
			case '\t':
			case '\n':
			case '\r':
				// case '\b':

				// case '\f':

				break;
			default:
				return false;
			}
		}
		return true;
	}

	public static boolean notBlank(String str) {
		return !isBlank(str);
	}

	public static boolean notBlank(String... strings) {
		if (strings == null || strings.length == 0) {
			return false;
		}
		for (String str : strings) {
			if (isBlank(str)) {
				return false;
			}
		}
		return true;
	}

	public static boolean notNull(Object... paras) {
		if (paras == null) {
			return false;
		}
		for (Object obj : paras) {
			if (obj == null) {
				return false;
			}
		}
		return true;
	}
	
	/**
	 * 
	 * @Title: isEmpty   
	 * @Description: TODO(判断对象为null)   
	 * @param: @param obj
	 * @param: @return      
	 * @return: boolean      
	 * @throws
	 */
	@SuppressWarnings("rawtypes")
	public static boolean isEmpty(Object obj) {
		if (obj == null) {
			return true;
		}
		if ((obj instanceof List)) {
			return ((List) obj).size() == 0;
		}
		return false;
	}
	/**
	 * 
	 * @Title: isEmptyByTrim   
	 * @Description: TODO(判断对象去除空格后为null)   
	 * @param: @param obj
	 * @param: @return      
	 * @return: boolean      
	 * @throws
	 */
	@SuppressWarnings("rawtypes")
	public static boolean isEmptyByTrim(Object obj) {
		if (obj == null) {
			return true;
		}
		if ((obj instanceof List)) {
			return ((List) obj).size() == 0;
		}
		if ((obj instanceof String)) {
			return ((String) obj).trim().equals("");
		}
		return false;
	}

	/**
	 * 字符串是否为空，空的定义如下 1、为null <br>
	 * 2、为""<br>
	 * 
	 * @param str
	 *            被检测的字符串
	 * @return 是否为空
	 */
	public static boolean isEmpty(String str) {
		return str == null || str.length() == 0;
	}

	public static boolean isEmpty(Object[] array) {
		return (array == null || array.length == 0);
	}

	/**
	 * 字符串是否为非空白 空白的定义如下： <br>
	 * 1、不为null <br>
	 * 2、不为""<br>
	 * 
	 * @param str
	 *            被检测的字符串
	 * @return 是否为非空
	 */
	public static boolean isNotEmpty(String str) {
		return false == isEmpty(str);
	}

	/**
	 * @Title: replace @Description: TODO(这里用一句话描述这个方法的作用) @param @param
	 * inString @param @param oldPattern @param @param newPattern @param @return
	 * 参数 @return String 返回类型 @throws
	 */
	public static String replace(String inString, String oldPattern, String newPattern) {
		if (inString == null) {
			return null;
		}
		if (oldPattern == null || newPattern == null) {
			return inString;
		}

		StringBuffer sbuf = new StringBuffer();
		// output StringBuffer we'll build up
		int pos = 0; // our position in the old string
		int index = inString.indexOf(oldPattern);
		// the index of an occurrence we've found, or -1
		int patLen = oldPattern.length();
		while (index >= 0) {
			sbuf.append(inString.substring(pos, index));
			sbuf.append(newPattern);
			pos = index + patLen;
			index = inString.indexOf(oldPattern, pos);
		}
		sbuf.append(inString.substring(pos));

		// remember to append any characters to the right of a match
		return sbuf.toString();
	}

	/**
	 * @Title: subBefore @Description: TODO( 截取分隔字符串之前的字符串，不包括分隔字符串<br>
	 * 如果给定的字符串为空串（null或""）或者分隔字符串为null，返回原字符串<br>
	 * 如果分隔字符串为空串""，则返回空串，如果分隔字符串未找到，返回原字符串 @param @param str @param @param
	 * separator @param @param isLastSeparator @param @return 参数 @return String
	 * 返回类型 @throws
	 */
	public static String subBefore(String str, String separator, boolean isLastSeparator) {
		if (isEmpty(str) || separator == null) {
			return null == str ? null : str.toString();
		}
		if (separator.isEmpty()) {
			return EMPTY;
		}
		int pos = isLastSeparator ? str.lastIndexOf(separator) : str.indexOf(separator);
		if (pos == INDEX_NOT_FOUND) {
			return str;
		}
		return str.substring(0, pos);
	}

	/**
	 * @Title: subBefore @Description: TODO( 截取分隔字符串之后的字符串，不包括分隔字符串<br>
	 * 如果给定的字符串为空串（null或""），返回原字符串<br>
	 * 如果分隔字符串为空串（null或""），则返回空串，如果分隔字符串未找到，返回空串 @param @param str
	 * 被查找的字符串 @param @param separator 分隔字符串 @param @param isLastSeparator
	 * 是否查找最后一个分隔字符串（多次出现分隔字符串时选取最后一个），true为选取最后一个 @param @return
	 * 切割后的字符串 @return String 返回类型 @throws
	 */
	public static String subAfter(String str, String separator, boolean isLastSeparator) {
		if (isEmpty(str)) {
			return null == str ? null : str.toString();
		}
		if (separator == null) {
			return EMPTY;
		}
		final int pos = isLastSeparator ? str.lastIndexOf(separator) : str.indexOf(separator);
		if (pos == INDEX_NOT_FOUND) {
			return EMPTY;
		}
		return str.substring(pos + separator.length());
	}

	/**
	 * 字符串是否以给定字符开始
	 * 
	 * @param s1
	 *            字符串
	 * @param s2
	 *            字符
	 * @return 是否开始
	 */
	public static boolean startWith(String s1, String s2) {
		if (isBlank(s2) && !isBlank(s1)) {
			return false;
		}
		return s2.equals(new String(s1.substring(s1.length() - 1, s1.length())));
	}

	/**
	 * 字符串是否以给定字符结束
	 * 
	 * @param s1
	 *            字符串
	 * @param s2
	 *            字符
	 * @return 是否开始
	 */
	public static boolean endWith(String s1, String s2) {
		if (isBlank(s2) && !isBlank(s1)) {
			return false;
		}
		return s2.equals(new String(s1.substring(0, 1)));
	}

	/**
	 * 去除两边的指定字符串
	 * 
	 * @param s1
	 *            被处理的字符串
	 * @param s2
	 *            去除的字符串
	 * @return 处理后的字符串
	 */
	public static String shiftOutEnd2End(String s1, String s2) {
		return shiftOut(s1, s2, s2);
	}

	/**
	 * 去除两边的指定字符串
	 * 
	 * @param str
	 *            被处理的字符串
	 * @param prefix
	 *            头部去除的字符串
	 * @param suffix
	 *            尾部去除的字符串
	 * @return 处理后的字符串
	 */
	public static String shiftOut(String str, String prefix, String suffix) {
		if (isBlank(str)) {
			return str;
		}
		int from = 0;
		int to = str.length();

		String str2 = str.toString();
		if (startWith(str2, prefix)) {
			from = prefix.length();
		}
		if (endWith(str2, suffix)) {
			to -= suffix.length();
		}
		return str2.substring(from, to);
	}
	
	/**
	    * @Title: concat
	    * @Description: TODO(字符串拼接)
	    * @param @param name
	    * @param @param paras
	    * @param @return    参数
	    * @return String    返回类型
	    * @throws
	 */
	public static String concat(String name, Object... paras) {
		StringBuffer sf = new StringBuffer(name);
		for (Object o : paras) {
			sf.append(o);
		}
		return sf.toString();
	}
	/**
	 * @Title: insert   
	 * @Description: TODO(每个多少位插入某个字符串)   
	 * @param: @param s1 原始字符串
	 * @param: @param number
	 * @param: @param s2 待插入字符串
	 * @param: @return      
	 * @return: String      
	 * @throws
	 */
	public static String insert(String s1,int number,String s2) {
        StringBuilder str = new StringBuilder(s1);
        int last = str.length();
        for(int i = last - number; i > 0; i-=number) {
            str.insert(i,s2);
        }
        return str.toString();
	}
}
