/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.boot.kit.bean;

import com.ovopark.boot.kit.json.JacksonKit;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanCopyKit {
    protected static final Logger log = LoggerFactory.getLogger(BeanCopyKit.class);

    private static Object getProperty(Object bean, String propertyName) {
        Class<?> clazz = bean.getClass();
        try {
            Field field = clazz.getDeclaredField(propertyName);
            Method method = clazz.getDeclaredMethod(BeanCopyKit.getGetterName(field.getName(), field.getType()), new Class[0]);
            return method.invoke(bean, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String getGetterName(String propertyName) {
        String method = propertyName.length() > 1 && Character.isUpperCase(propertyName.charAt(1)) ? "get" + propertyName : "get" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        return method;
    }

    private static String getGetterName(String propertyName, Class<?> type) {
        if (type == Boolean.class || type == Boolean.TYPE) {
            if ("is".equalsIgnoreCase(propertyName.substring(0, 2))) {
                return propertyName;
            }
            return "is" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        }
        String method = propertyName.length() > 1 && Character.isUpperCase(propertyName.charAt(1)) ? "get" + propertyName : "get" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        return method;
    }

    private static Object getSourPropertyValue(Object sourceBean, String sourcePropertyName) {
        Class<?> clazz = sourceBean.getClass();
        try {
            Field field = clazz.getDeclaredField(sourcePropertyName);
            Method method = clazz.getDeclaredMethod(BeanCopyKit.getGetterName(field.getName(), field.getType()), new Class[0]);
            return method.invoke(sourceBean, new Object[0]);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5c5e\u6027\u540d\uff08\u4e0d\u533a\u5206\u5927\u5c0f\u5199\uff09\u76f8\u4f3c\u7684\u503c\u8d4b\u503c\u51fa\u5dee", (Throwable)e);
            return null;
        }
    }

    private static String getSetterName(String propertyName) {
        String method = propertyName.length() > 1 && Character.isUpperCase(propertyName.charAt(1)) ? "set" + propertyName : "set" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        return method;
    }

    private static Object setObjPropertyBySourceProperty(Object objBean, String sourcePropertyName, Object value) {
        Class<?> clazz = objBean.getClass();
        Field[] fields = clazz.getDeclaredFields();
        try {
            int j = fields.length;
            for (int i = 0; i < j; ++i) {
                String propertyName = fields[i].getName();
                if (!sourcePropertyName.equalsIgnoreCase(propertyName)) continue;
                Field field = clazz.getDeclaredField(propertyName);
                if (field.getType() == BigDecimal.class) {
                    if (value instanceof String) {
                        value = new BigDecimal(String.valueOf(value));
                    } else if (value instanceof Integer || value instanceof Double) {
                        value = BigDecimal.valueOf(Double.parseDouble(String.valueOf(value)));
                    }
                }
                if ((field.getType() == Double.class || field.getType() == Double.TYPE) && value instanceof BigDecimal) {
                    DecimalFormat df = new DecimalFormat("#.000000");
                    Double v = Double.parseDouble(String.valueOf(value));
                    value = df.format(v);
                }
                Method method = clazz.getDeclaredMethod(BeanCopyKit.getSetterName(field.getName()), field.getType());
                return method.invoke(objBean, value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static Object setObjProperty(Object objBean, String propertyName, Object value) {
        Class<?> clazz = objBean.getClass();
        try {
            Field field = clazz.getDeclaredField(propertyName);
            if (field.getType() == BigDecimal.class) {
                if (value instanceof String) {
                    value = new BigDecimal(String.valueOf(value));
                } else if (value instanceof Integer || value instanceof Double) {
                    value = BigDecimal.valueOf(Double.parseDouble(String.valueOf(value)));
                }
            }
            if ((field.getType() == Double.class || field.getType() == Double.TYPE) && value instanceof BigDecimal) {
                DecimalFormat df = new DecimalFormat("#.000000");
                Double v = Double.parseDouble(String.valueOf(value));
                value = new BigDecimal(df.format(v));
            }
            if ((field.getType() == Integer.class || field.getType() == Integer.TYPE) && value instanceof Float) {
                value = Math.round(Float.parseFloat(String.valueOf(value)));
            }
            Method method = clazz.getDeclaredMethod(BeanCopyKit.getSetterName(field.getName()), field.getType());
            log.info("\u7ed9\u76ee\u6807bean\u8d4b\u503c,propertyName:{},value:{}", (Object)propertyName, value);
            Object obj = method.invoke(objBean, value);
            return obj;
        }
        catch (Exception e) {
            log.error("\u7ed9\u76ee\u6807bean\u8d4b\u503c\u51fa\u9519,propertyName:{},value:{}", new Object[]{propertyName, value, e});
            return null;
        }
    }

    public static Object copyByIgnoreCase(Object obj, Object source, boolean isCover) {
        try {
            Field[] objFields = obj.getClass().getDeclaredFields();
            Field[] sourFields = source.getClass().getDeclaredFields();
            block4: for (int i = 0; i < sourFields.length; ++i) {
                String sourcePropertyName = sourFields[i].getName();
                Object propertyValue = BeanCopyKit.getSourPropertyValue(source, sourcePropertyName);
                for (int j = 0; j < objFields.length; ++j) {
                    try {
                        String objPropertyName = objFields[j].getName();
                        if (!objPropertyName.equalsIgnoreCase(sourcePropertyName)) continue;
                        if (isCover) {
                            if (BeanCopyKit.getProperty(obj, objPropertyName) != null || propertyValue == null) continue block4;
                            BeanCopyKit.setObjProperty(obj, objPropertyName, propertyValue);
                            continue block4;
                        }
                        BeanCopyKit.setObjProperty(obj, objPropertyName, propertyValue);
                        continue block4;
                    }
                    catch (Exception e) {
                        log.error("\u7ed9\u76ee\u6807bean\u8d4b\u503c\u51fa\u9519,objPropertyName:{},value:{}", new Object[]{sourcePropertyName, propertyValue, e});
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            log.error("\u7ed9\u76ee\u6807bean\u8d4b\u503c\u51fa\u9519,obje:{},sour:{}", new Object[]{JacksonKit.toJSon(obj), JacksonKit.toJSon(source), e});
        }
        return obj;
    }
}

