/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.boot.kit.dc;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Maps;
import com.ovopark.boot.common.entity.CurrentUser;
import com.ovopark.boot.kit.http.OvoparkHttpClientKit;
import com.ovopark.boot.kit.json.Jackson2Kit;
import com.ovopark.boot.kit.lang.StrKit;
import com.ovopark.boot.utils.lang.ConvertUtils;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class DcTokenKit {
    private static OvoparkHttpClientKit httpCilent = OvoparkHttpClientKit.init();
    static final String authenticator = "authenticator";
    static final String ovoAuthorization = "Ovo-Authorization";
    static final String parseTokenUrl = "/ovopark-sso/token/parseToken";
    static final String getUserByTokenUrl = "/api/business/base/user/v1/getUserByToken";
    private static final String formal = "formal";
    private static final String prod = "prod";

    public static CurrentUser getCurrentUser(HttpServletRequest request, String environment) {
        String oldToken = request.getHeader(authenticator);
        String newToken = request.getHeader(ovoAuthorization);
        boolean isNewToken = !StrKit.isBlank(newToken);
        CurrentUser user = new CurrentUser();
        user.setAuthenticator(oldToken);
        user.setOvoAuthorization(newToken);
        user.setNewToken(isNewToken);
        Map data = Maps.newHashMap();
        String string = environment = environment.equals(formal) ? prod : environment;
        if (isNewToken) {
            HashMap params = Maps.newHashMap();
            params.put("token", newToken);
            environment = "new_" + environment;
            String url = TokenEnvironment.getValue(environment) + parseTokenUrl;
            String result = httpCilent.doGet(url, params);
            data = (Map)Jackson2Kit.json2Object(result, new TypeReference<Map<String, Object>>(){});
            user.setUserId(ConvertUtils.toInt(data.get("userId")));
        } else {
            HashMap headers = Maps.newHashMap();
            headers.put(authenticator, oldToken);
            environment = "old_" + environment;
            String url = TokenEnvironment.getValue(environment) + getUserByTokenUrl;
            String result = httpCilent.doGet(url, Maps.newHashMap(), headers);
            data = (Map)Jackson2Kit.json2Object(result, new TypeReference<Map<String, Object>>(){});
            user.setUserId(ConvertUtils.toInt(data.get("id")));
        }
        user.setUserName(ConvertUtils.toStr(data.get("userName")));
        user.setGroupId(ConvertUtils.toInt(data.get("groupId")));
        return user;
    }

    public static CurrentUser getUser(String url, String newToken) {
        HashMap params = Maps.newHashMap();
        params.put("token", newToken);
        String result = httpCilent.doGet(url, params);
        Map data = (Map)Jackson2Kit.json2Object(result, new TypeReference<Map<String, Object>>(){});
        CurrentUser user = new CurrentUser();
        user.setOvoAuthorization(newToken);
        user.setNewToken(true);
        user.setUserId(ConvertUtils.toInt(data.get("userId")));
        user.setUserName(ConvertUtils.toStr(data.get("userName")));
        user.setGroupId(ConvertUtils.toInt(data.get("groupId")));
        return user;
    }

    public static enum TokenEnvironment {
        old_dev("old_dev", "http://test.business.ovopark.com"),
        old_test("old_test", "http://test.business.ovopark.com"),
        old_prod("old_prod", "http://business.ovopark.com"),
        new_dev("new_dev", "http://47.96.139.143:8819"),
        new_test("new_test", "http://47.96.139.143:8819"),
        new_prod("new_prod", "http://47.96.139.143:8819");

        private String key;
        private String value;

        private TokenEnvironment(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public static String getValue(String key) {
            for (TokenEnvironment c : TokenEnvironment.values()) {
                if (!c.getKey().equals(key)) continue;
                return c.value;
            }
            return null;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

