/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.boot.kit.http;

import com.alibaba.fastjson.JSONObject;
import com.ovopark.boot.kit.http.HttpClientKit;
import com.ovopark.boot.kit.lang.StrKit;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

public class IPKit {
    static final String IPV4_REGEX = "\\A(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3}\\z";

    public static String getWindowsLocalIP() {
        String localip = null;
        String netip = null;
        try {
            Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
            InetAddress ip = null;
            boolean finded = false;
            block2: while (netInterfaces.hasMoreElements() && !finded) {
                NetworkInterface ni = netInterfaces.nextElement();
                Enumeration<InetAddress> address = ni.getInetAddresses();
                while (address.hasMoreElements()) {
                    ip = address.nextElement();
                    if (!ip.isSiteLocalAddress() && !ip.isLoopbackAddress() && ip.getHostAddress().indexOf(":") == -1) {
                        netip = ip.getHostAddress();
                        finded = true;
                        continue block2;
                    }
                    if (!ip.isSiteLocalAddress() || ip.isLoopbackAddress() || ip.getHostAddress().indexOf(":") != -1) continue;
                    localip = ip.getHostAddress();
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        if (netip != null && !"".equals(netip)) {
            return netip;
        }
        return localip;
    }

    private static String getLinuxLocalIP() {
        String ip = "UNKNOW";
        try {
            Enumeration<NetworkInterface> e1 = NetworkInterface.getNetworkInterfaces();
            while (e1.hasMoreElements()) {
                NetworkInterface ni = e1.nextElement();
                if (!ni.getName().equals("eth0")) continue;
                Enumeration<InetAddress> e2 = ni.getInetAddresses();
                while (e2.hasMoreElements()) {
                    InetAddress ia = e2.nextElement();
                    if (ia instanceof Inet6Address) continue;
                    ip = ia.getHostAddress();
                }
                break;
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return ip;
    }

    public static String getInnetIp() {
        return IPKit.isWindowsOS() ? IPKit.getWindowsLocalIP() : IPKit.getLinuxLocalIP();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getV4IP() {
        String ip = "";
        String chinaz = "http://ip.tool.chinaz.com/";
        StringBuilder inputLine = new StringBuilder();
        String read = "";
        URL url = null;
        HttpURLConnection urlConnection = null;
        BufferedReader in = null;
        try {
            url = new URL(chinaz);
            urlConnection = (HttpURLConnection)url.openConnection();
            in = new BufferedReader(new InputStreamReader(urlConnection.getInputStream(), "UTF-8"));
            while ((read = in.readLine()) != null) {
                inputLine.append(read + "\r\n");
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        Pattern p = Pattern.compile("\\<dd class\\=\"fz24\">(.*?)\\<\\/dd>");
        Matcher m = p.matcher(inputLine.toString());
        if (m.find()) {
            String ipstr;
            ip = ipstr = m.group(1);
        }
        return ip;
    }

    public static String getV4IP2() {
        String ip = "";
        try {
            String read;
            String requetUrl = "http://pv.sohu.com/cityjson?ie=utf-8";
            URL url = new URL(requetUrl);
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
            StringBuilder stringBuilder = new StringBuilder();
            while ((read = in.readLine()) != null) {
                stringBuilder.append(read);
            }
            String string = stringBuilder.toString().split("=")[1];
            JSONObject jsonObject = JSONObject.parseObject((String)string.replace(";", ""));
            ip = jsonObject.get((Object)"cip").toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ip;
    }

    public static String getV4IP3(String requestUrl) {
        String ip = "";
        try {
            String requestHtml;
            if (StrKit.isEmpty(requestUrl)) {
                requestUrl = "http://2000019.ip138.com/";
            }
            if (StrKit.isNotEmpty(requestHtml = HttpClientKit.init().doGet(requestUrl)) && requestHtml.contains("\u60a8\u7684IP\u5730\u5740\u662f\uff1a[")) {
                String startIndex = "\u60a8\u7684IP\u5730\u5740\u662f\uff1a[";
                String endIndex = "] \u6765\u81ea\uff1a";
                int start = requestHtml.indexOf(startIndex);
                int end = requestHtml.indexOf(endIndex);
                ip = requestHtml.substring(start + startIndex.length(), end);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ip;
    }

    public static String getAddresses(String content, String encoding) throws UnsupportedEncodingException {
        String urlStr = "http://ip.taobao.com/service/getIpInfo.php";
        String returnStr = IPKit.getResult(urlStr, content, encoding);
        if (returnStr != null) {
            String[] temp = returnStr.split(",");
            if (temp.length < 3) {
                return "0";
            }
            String country = "";
            String area = "";
            String region = "";
            String city = "";
            String county = "";
            String isp = "";
            block8: for (int i = 0; i < temp.length; ++i) {
                switch (i) {
                    case 2: {
                        country = temp[i].split(":")[1].replaceAll("\"", "");
                        country = URLDecoder.decode(country, encoding);
                        continue block8;
                    }
                    case 3: {
                        area = temp[i].split(":")[1].replaceAll("\"", "");
                        area = URLDecoder.decode(area, encoding);
                        continue block8;
                    }
                    case 4: {
                        region = temp[i].split(":")[1].replaceAll("\"", "");
                        region = URLDecoder.decode(region, encoding);
                        continue block8;
                    }
                    case 5: {
                        city = temp[i].split(":")[1].replaceAll("\"", "");
                        city = URLDecoder.decode(city, encoding);
                        if (!"\u5185\u7f51IP".equals(city)) continue block8;
                        return "\u5730\u5740\u4e3a\uff1a\u5185\u7f51IP";
                    }
                    case 6: {
                        county = temp[i].split(":")[1].replaceAll("\"", "");
                        county = URLDecoder.decode(county, encoding);
                        continue block8;
                    }
                    case 7: {
                        isp = temp[i].split(":")[1].replaceAll("\"", "");
                        isp = URLDecoder.decode(isp, encoding);
                    }
                }
            }
            return new StringBuffer("\u5730\u5740\u4e3a\uff1a" + country + ",").append(region + "\u7701,").append(city + "\u5e02,").append(county + ",").append(isp).toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getResult(String urlStr, String content, String encoding) {
        URL url = null;
        HttpURLConnection connection = null;
        try {
            url = new URL(urlStr);
            connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(2000);
            connection.setReadTimeout(33000);
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setRequestMethod("POST");
            connection.setUseCaches(false);
            connection.connect();
            DataOutputStream out = new DataOutputStream(connection.getOutputStream());
            out.writeBytes(content);
            out.flush();
            out.close();
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), encoding));
            StringBuffer buffer = new StringBuffer();
            String line = "";
            while ((line = reader.readLine()) != null) {
                buffer.append(line);
            }
            reader.close();
            String string = buffer.toString();
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return null;
    }

    public static boolean isWindowsOS() {
        boolean isWindowsOS = false;
        String osName = System.getProperty("os.name");
        if (osName.toLowerCase().indexOf("windows") > -1) {
            isWindowsOS = true;
        }
        return isWindowsOS;
    }

    public static String getIpByRequest(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip.equals("0:0:0:0:0:0:0:1") ? "127.0.0.1" : ip;
    }

    public static String dnsToIp(String domainName) {
        try {
            return InetAddress.getByName(domainName).getHostAddress();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isIPV4(String host) {
        return host.matches(IPV4_REGEX);
    }

    public static void main(String[] args) {
        String ip1 = IPKit.getInnetIp();
        System.out.println("\u5185\u7f51ip:" + ip1);
        String ip2 = IPKit.getV4IP();
        System.out.println("\u5916\u7f51ip:" + ip2);
        String address = "";
        try {
            address = IPKit.getAddresses("ip=" + ip2, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        System.out.println("\u60a8\u7684" + address);
    }
}

