/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.boot.kit.http;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ovopark.boot.kit.http.HttpDeleteKit;
import com.ovopark.boot.kit.reflect.ReflectKit;
import com.ovopark.boot.utils.lang.ConvertUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeaderElementIterator;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OvoparkHttpClientKit {
    private static final Logger logger = LoggerFactory.getLogger(OvoparkHttpClientKit.class);
    private static PoolingHttpClientConnectionManager connMag;
    private static RequestConfig requestConfig;
    private static final int SocketTimeout = 30000;
    private static final int ConnectTimeout = 10000;
    private static final int ConnectionRequestTimeout = 10000;
    private static int maxThreadsTotal;
    private static int maxThreadsPerHost;
    private static CloseableHttpClient httpClient;
    static final String HTTPCLIENT_ERROR = "APIGETWAY_HTTP_ERROR";

    public static OvoparkHttpClientKit init() {
        return initHttp.instance.init();
    }

    public String doGet(String url) {
        return this.doGet(url, new HashMap<String, Object>());
    }

    public String doGet(String url, Map<String, Object> params) {
        return this.doGet(url, params, null);
    }

    public String doGet(String url, Map<String, Object> params, Map<String, Object> headers) {
        String result = null;
        try {
            CloseableHttpResponse closeableHttpResponse;
            HttpEntity httpEntity;
            String apiUrl = url;
            StringBuffer param = new StringBuffer();
            int i = 0;
            for (String string : params.keySet()) {
                if (i == 0) {
                    param.append("?");
                } else {
                    param.append("&");
                }
                param.append(string).append("=").append(URLEncoder.encode(ConvertUtils.toStr(params.get(string)), "utf-8"));
                ++i;
            }
            apiUrl = apiUrl + param;
            HttpGet httpGet = new HttpGet(apiUrl);
            if (headers != null) {
                Iterator<Map.Entry<String, Object>> iterator = headers.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, Object> entry;
                    Map.Entry<String, Object> entry2 = entry = iterator.next();
                    String key = entry2.getKey();
                    String value = (String)entry2.getValue();
                    httpGet.addHeader(key, value);
                }
            }
            if ((httpEntity = (closeableHttpResponse = httpClient.execute((HttpUriRequest)httpGet)).getEntity()) != null) {
                InputStream instream = httpEntity.getContent();
                result = IOUtils.toString((InputStream)instream, (String)"UTF-8");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public String doPost(String apiUrl) {
        return this.doPost(apiUrl, new HashMap<String, Object>());
    }

    public String doPost(String apiUrl, Map<String, Object> params) {
        return this.doPost(apiUrl, params, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doPost(String apiUrl, Map<String, Object> params, Map<String, Object> headers) {
        String httpStr = null;
        HttpPost httpPost = new HttpPost(apiUrl);
        CloseableHttpResponse response = null;
        try {
            ArrayList<BasicNameValuePair> pairList = new ArrayList<BasicNameValuePair>(params.size());
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                BasicNameValuePair pair = new BasicNameValuePair(entry.getKey(), entry.getValue().toString());
                pairList.add(pair);
            }
            if (headers != null) {
                Iterator<Map.Entry<String, Object>> iterator = headers.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, Object> obj;
                    Map.Entry<String, Object> entry = obj = iterator.next();
                    String key = entry.getKey();
                    String value = (String)entry.getValue();
                    httpPost.addHeader(key, value);
                }
            }
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairList, Charset.forName("UTF-8")));
            response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = response.getEntity();
            httpStr = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        catch (IOException e) {
            logger.info("doPost error:{}", (Throwable)e);
            e.printStackTrace();
            httpStr = HTTPCLIENT_ERROR;
        }
        finally {
            if (response != null) {
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return httpStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doPost(String apiUrl, Object obj) {
        String httpStr = null;
        HttpPost httpPost = new HttpPost(apiUrl);
        CloseableHttpResponse response = null;
        try {
            Class<?> clazz = obj.getClass();
            Field[] fields = ReflectKit.getNeedFields(clazz);
            ArrayList<BasicNameValuePair> pairList = new ArrayList<BasicNameValuePair>(fields.length);
            for (Field field : fields) {
                field.setAccessible(true);
                String fieldName = field.getName();
                Object o = ReflectKit.getFieldValue(obj, fieldName);
                String value = null;
                value = ReflectKit.isLangType(o) ? ConvertUtils.toStr(o, "") : JSON.toJSONString((Object)o);
                BasicNameValuePair pair = new BasicNameValuePair(fieldName, value);
                pairList.add(pair);
            }
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairList, Charset.forName("UTF-8")));
            response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = response.getEntity();
            httpStr = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
            httpStr = HTTPCLIENT_ERROR;
        }
        finally {
            if (response != null) {
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return httpStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String postFile(String apiUrl, File file) {
        String httpStr = null;
        HttpPost httpPost = new HttpPost(apiUrl);
        CloseableHttpResponse response = null;
        try {
            MultipartEntityBuilder mEntityBuilder = MultipartEntityBuilder.create();
            mEntityBuilder.addBinaryBody("file", file);
            httpPost.setEntity(mEntityBuilder.build());
            response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = response.getEntity();
            httpStr = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
            httpStr = HTTPCLIENT_ERROR;
        }
        finally {
            if (response != null) {
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return httpStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doGetJson(String apiUrl, JSONObject jsonObj, Map<String, String> headers) {
        String httpStr = null;
        CloseableHttpResponse response = null;
        try {
            if (!jsonObj.isEmpty()) {
                for (Object key : jsonObj.keySet()) {
                    if (apiUrl.indexOf(63) == -1) {
                        apiUrl = apiUrl + "?" + (String)key + "=" + jsonObj.get(key);
                        continue;
                    }
                    apiUrl = apiUrl + "&" + (String)key + "=" + jsonObj.get(key);
                }
            }
            HttpGet httpGet = new HttpGet(apiUrl);
            httpGet.setHeader("Content-type", "application/json");
            if (headers != null) {
                for (Object e : headers.entrySet()) {
                    Map.Entry entry = (Map.Entry)e;
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    httpGet.addHeader(key, value);
                }
            }
            response = httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity entity = response.getEntity();
            httpStr = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
            httpStr = HTTPCLIENT_ERROR;
        }
        finally {
            if (response != null) {
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return httpStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doPostJson(String apiUrl, String json, Map<String, String> headers) {
        String httpStr = null;
        CloseableHttpResponse response = null;
        try {
            HttpPost httpPost = new HttpPost(apiUrl);
            httpPost.setHeader("Content-type", "application/json");
            if (headers != null) {
                Iterator<Map.Entry<String, String>> iterator = headers.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, String> obj;
                    Map.Entry<String, String> entry = obj = iterator.next();
                    String key = entry.getKey();
                    String value = entry.getValue();
                    httpPost.addHeader(key, value);
                }
            }
            StringEntity stringEntity = new StringEntity(json, "UTF-8");
            stringEntity.setContentEncoding("UTF-8");
            stringEntity.setContentType("application/json");
            httpPost.setEntity((HttpEntity)stringEntity);
            response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = response.getEntity();
            httpStr = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
            httpStr = HTTPCLIENT_ERROR;
        }
        finally {
            if (response != null) {
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return httpStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doPutJson(String apiUrl, String json, Map<String, String> headers) {
        String httpStr = null;
        CloseableHttpResponse response = null;
        try {
            HttpPut httpput = new HttpPut(apiUrl);
            httpput.setHeader("Content-type", "application/json");
            if (headers != null) {
                Iterator<Map.Entry<String, String>> iterator = headers.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, String> obj;
                    Map.Entry<String, String> entry = obj = iterator.next();
                    String key = entry.getKey();
                    String value = entry.getValue();
                    httpput.addHeader(key, value);
                }
            }
            StringEntity stringEntity = new StringEntity(json, "UTF-8");
            stringEntity.setContentEncoding("UTF-8");
            stringEntity.setContentType("application/json");
            httpput.setEntity((HttpEntity)stringEntity);
            response = httpClient.execute((HttpUriRequest)httpput);
            HttpEntity entity = response.getEntity();
            httpStr = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
            httpStr = HTTPCLIENT_ERROR;
        }
        finally {
            if (response != null) {
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return httpStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doDeleteJson(String apiUrl, String json, Map<String, String> headers) {
        String httpStr = null;
        CloseableHttpResponse response = null;
        try {
            HttpDeleteKit httpdelete = new HttpDeleteKit(apiUrl);
            httpdelete.setHeader("Content-type", "application/json");
            if (headers != null) {
                Iterator<Map.Entry<String, String>> iterator = headers.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, String> obj;
                    Map.Entry<String, String> entry = obj = iterator.next();
                    String key = entry.getKey();
                    String value = entry.getValue();
                    httpdelete.addHeader(key, value);
                }
            }
            StringEntity stringEntity = new StringEntity(json, "UTF-8");
            stringEntity.setContentEncoding("UTF-8");
            stringEntity.setContentType("application/json");
            httpdelete.setEntity((HttpEntity)stringEntity);
            response = httpClient.execute((HttpUriRequest)httpdelete);
            HttpEntity entity = response.getEntity();
            httpStr = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
            httpStr = HTTPCLIENT_ERROR;
        }
        finally {
            if (response != null) {
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return httpStr;
    }

    static {
        maxThreadsTotal = 500;
        maxThreadsPerHost = 50;
    }

    private static enum initHttp {
        instance;

        private OvoparkHttpClientKit t = new OvoparkHttpClientKit();

        private initHttp() {
            connMag = new PoolingHttpClientConnectionManager();
            connMag.setMaxTotal(maxThreadsTotal);
            connMag.setDefaultMaxPerRoute(maxThreadsPerHost);
            RequestConfig.Builder configBuilder = RequestConfig.custom();
            configBuilder.setConnectTimeout(10000);
            configBuilder.setSocketTimeout(30000);
            configBuilder.setConnectionRequestTimeout(10000);
            requestConfig = configBuilder.build();
            ConnectionKeepAliveStrategy myStrategy = new ConnectionKeepAliveStrategy(){

                public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                    BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
                    while (it.hasNext()) {
                        HeaderElement he = it.nextElement();
                        String param = he.getName();
                        String value = he.getValue();
                        if (value == null || !param.equalsIgnoreCase("timeout")) continue;
                        return Long.parseLong(value) * 1000L;
                    }
                    return 60000L;
                }
            };
            httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connMag).setKeepAliveStrategy(myStrategy).setDefaultRequestConfig(requestConfig).build();
        }

        private OvoparkHttpClientKit init() {
            return this.t;
        }
    }
}

