/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.boot.kit.json;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.JSONLibDataFormatSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class FastJsonKit {
    private static final SerializeConfig config = new SerializeConfig();
    private static final SerializerFeature[] features;

    public static String convertObjectToJSON(Object object) {
        return JSON.toJSONString((Object)object, (SerializeConfig)config, (SerializerFeature[])features);
    }

    public static String toJSONNoFeatures(Object object) {
        return JSON.toJSONString((Object)object, (SerializeConfig)config, (SerializerFeature[])new SerializerFeature[0]);
    }

    public static <T> T getJsonToBean(String text, Class<T> clazz) {
        return (T)JSON.parseObject((String)text, clazz);
    }

    public static String getBeanToJson(Object object) {
        return JSON.toJSONString((Object)object);
    }

    public static <T> List<T> getJsonToList(String jsonData, Class<T> clazz) {
        return JSON.parseArray((String)jsonData, clazz);
    }

    public static List<Map<String, Object>> getJsonToListMap(String jsonData) {
        return (List)JSON.parseObject((String)jsonData, (TypeReference)new TypeReference<List<Map<String, Object>>>(){}, (Feature[])new Feature[0]);
    }

    static {
        config.put(Date.class, (ObjectSerializer)new JSONLibDataFormatSerializer());
        config.put(java.sql.Date.class, (ObjectSerializer)new JSONLibDataFormatSerializer());
        features = new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullListAsEmpty, SerializerFeature.WriteNullNumberAsZero, SerializerFeature.WriteNullBooleanAsFalse, SerializerFeature.WriteNullStringAsEmpty};
    }
}

