/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.boot.kit.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.ovopark.boot.kit.lang.StrKit;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class Jackson2Kit {
    private static ObjectMapper objectMapper = new ObjectMapper();

    public static <T> String objToJson(T obj) {
        if (obj == null) {
            return null;
        }
        try {
            return obj instanceof String ? (String)obj : objectMapper.writeValueAsString(obj);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> String objToJsonPretty(T obj) {
        if (obj == null) {
            return null;
        }
        try {
            return obj instanceof String ? (String)obj : objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(obj);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> T json2Object(String json, Class<T> clazz) {
        if (StrKit.isEmpty(json) || clazz == null) {
            return null;
        }
        try {
            return (T)(clazz.equals(String.class) ? json : objectMapper.readValue(json, clazz));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> T json2Object(String json, TypeReference<?> typeReference) {
        if (StrKit.isEmpty(json) || typeReference == null) {
            return null;
        }
        try {
            return (T)(typeReference.getType().equals(String.class) ? json : objectMapper.readValue(json, typeReference));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> T json2Object(String json, Class<?> collectionClazz, Class<?> ... elements) {
        JavaType javaType = objectMapper.getTypeFactory().constructParametricType(collectionClazz, (Class[])elements);
        try {
            return (T)objectMapper.readValue(json, javaType);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> T treeToValue(JsonNode jsonNode, Class<T> clazz) {
        try {
            return (T)objectMapper.treeToValue((TreeNode)jsonNode, clazz);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static JsonNode getJsonNode(String jsonStr) {
        try {
            return objectMapper.readTree(jsonStr);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T json2Object(String json, JavaType valueType) {
        try {
            return (T)objectMapper.readValue(json, valueType);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static JavaType getJavaType(Type type) {
        if (type instanceof ParameterizedType) {
            Type[] actualTypeArguments = ((ParameterizedType)type).getActualTypeArguments();
            Class rowClass = (Class)((ParameterizedType)type).getRawType();
            JavaType[] javaTypes = new JavaType[actualTypeArguments.length];
            for (int i = 0; i < actualTypeArguments.length; ++i) {
                javaTypes[i] = Jackson2Kit.getJavaType(actualTypeArguments[i]);
            }
            return TypeFactory.defaultInstance().constructParametricType(rowClass, javaTypes);
        }
        Class cla = (Class)type;
        return TypeFactory.defaultInstance().constructParametricType(cla, new JavaType[0]);
    }

    static {
        objectMapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        objectMapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, true);
        objectMapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.getSerializerProvider().setNullValueSerializer((JsonSerializer)new JsonSerializer<Object>(){

            public void serialize(Object o, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
                jsonGenerator.writeString("");
            }
        });
    }
}

