/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.boot.kit.util.concurrent;

import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadManager {
    private static ThreadPollProxy mThreadPollProxy;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ThreadPollProxy getThreadPollProxy() {
        Class<ThreadPollProxy> clazz = ThreadPollProxy.class;
        synchronized (ThreadPollProxy.class) {
            if (mThreadPollProxy == null) {
                mThreadPollProxy = new ThreadPollProxy(3, 6, 1000L);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return mThreadPollProxy;
        }
    }

    public static class ThreadPollProxy {
        private ThreadPoolExecutor poolExecutor;
        private int corePoolSize;
        private int maximumPoolSize;
        private long keepAliveTime;

        public ThreadPollProxy(int corePoolSize, int maximumPoolSize, long keepAliveTime) {
            this.corePoolSize = corePoolSize;
            this.maximumPoolSize = maximumPoolSize;
            this.keepAliveTime = keepAliveTime;
        }

        public void execute(Runnable r) {
            if (this.poolExecutor == null || this.poolExecutor.isShutdown()) {
                this.poolExecutor = new ThreadPoolExecutor(this.corePoolSize, this.maximumPoolSize, this.keepAliveTime, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), Executors.defaultThreadFactory());
            }
            this.poolExecutor.execute(r);
        }
    }
}

