/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.boot.office;

import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelUtil {
    private static final String excel2003L = ".xls";
    private static final String excel2007U = ".xlsx";
    private static final int EXCEL_MAX_ROW = 60000;

    public static List<List<Object>> getBankListByExcel(InputStream in, String fileName) throws Exception {
        ArrayList<List<Object>> list = null;
        Workbook work = ExcelUtil.getWorkbook(in, fileName);
        if (null == work) {
            throw new Exception("\u521b\u5efaExcel\u5de5\u4f5c\u8584\u4e3a\u7a7a\uff01");
        }
        Sheet sheet = null;
        Row row = null;
        Cell cell = null;
        list = new ArrayList<List<Object>>();
        for (int i = 0; i < work.getNumberOfSheets(); ++i) {
            sheet = work.getSheetAt(i);
            if (sheet == null) continue;
            for (int j = sheet.getFirstRowNum(); j <= sheet.getLastRowNum(); ++j) {
                row = sheet.getRow(j);
                if (row == null) continue;
                ArrayList<Object> li = new ArrayList<Object>();
                for (int y = row.getFirstCellNum(); y < row.getLastCellNum(); ++y) {
                    cell = row.getCell(y);
                    li.add(ExcelUtil.getCellValue(cell));
                }
                list.add(li);
            }
        }
        return list;
    }

    public static List<List<Object>> getBankListByExcel(InputStream in, String fileName, Integer sheetId) throws Exception {
        ArrayList<List<Object>> list = null;
        Workbook work = ExcelUtil.getWorkbook(in, fileName);
        if (null == work) {
            throw new Exception("\u521b\u5efaExcel\u5de5\u4f5c\u8584\u4e3a\u7a7a\uff01");
        }
        Sheet sheet = null;
        Row row = null;
        Cell cell = null;
        list = new ArrayList<List<Object>>();
        if (sheetId == null) {
            for (int i = 0; i < work.getNumberOfSheets(); ++i) {
                sheet = work.getSheetAt(i);
                if (sheet == null) continue;
                for (int j = sheet.getFirstRowNum(); j <= sheet.getLastRowNum(); ++j) {
                    row = sheet.getRow(j);
                    if (row == null) continue;
                    ArrayList<Object> li = new ArrayList<Object>();
                    for (int y = row.getFirstCellNum(); y < row.getLastCellNum(); ++y) {
                        cell = row.getCell(y);
                        li.add(ExcelUtil.getCellValue(cell));
                    }
                    list.add(li);
                }
            }
        } else {
            sheet = work.getSheetAt(sheetId.intValue());
            for (int j = sheet.getFirstRowNum(); j <= sheet.getLastRowNum(); ++j) {
                row = sheet.getRow(j);
                if (row == null) continue;
                ArrayList<Object> li = new ArrayList<Object>();
                for (int y = row.getFirstCellNum(); y < row.getLastCellNum(); ++y) {
                    cell = row.getCell(y);
                    li.add(ExcelUtil.getCellValue(cell));
                }
                list.add(li);
            }
        }
        return list;
    }

    public static Workbook getWorkbook(InputStream inStr, String fileName) throws Exception {
        HSSFWorkbook wb = null;
        String fileType = fileName.substring(fileName.lastIndexOf("."));
        if (excel2003L.equals(fileType)) {
            wb = new HSSFWorkbook(inStr);
        } else if (excel2007U.equals(fileType)) {
            wb = new XSSFWorkbook(inStr);
        } else {
            throw new Exception("\u89e3\u6790\u7684\u6587\u4ef6\u683c\u5f0f\u6709\u8bef\uff01");
        }
        return wb;
    }

    public static Object getCellValue(Cell cell) {
        Object value = null;
        if (cell != null) {
            DecimalFormat df = new DecimalFormat("#.#####");
            SimpleDateFormat sdf = new SimpleDateFormat("yyy-MM-dd");
            SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            DecimalFormat df2 = new DecimalFormat("0.00");
            switch (cell.getCellType()) {
                case 1: {
                    value = cell.getRichStringCellValue().getString();
                    break;
                }
                case 0: {
                    if ("General".equals(cell.getCellStyle().getDataFormatString())) {
                        value = df.format(cell.getNumericCellValue());
                        break;
                    }
                    if ("m/d/yy".equals(cell.getCellStyle().getDataFormatString())) {
                        value = sdf.format(cell.getDateCellValue());
                        break;
                    }
                    if ("m/d/yy h:mm".equals(cell.getCellStyle().getDataFormatString())) {
                        value = sdf2.format(cell.getDateCellValue());
                        break;
                    }
                    value = df2.format(cell.getNumericCellValue());
                    break;
                }
                case 4: {
                    value = cell.getBooleanCellValue();
                    break;
                }
                case 3: {
                    value = "";
                    break;
                }
            }
        }
        return value;
    }
}

