/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.boot.utils.date;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.springframework.util.StringUtils;

public class DateUtils {
    public static String FORMAT_NO_SECNOD = "yyyy-MM-dd HH:mm";
    public static String FORMAT_SHORT = "yyyy-MM-dd";
    public static String FORMAT_TIME = "HH:mm:ss";
    public static String FORMAT_TIME_SHORT = "HH";
    public static String FORMAT_LONG = "yyyy-MM-dd HH:mm:ss";
    public static String FORMAT_LONG_SLASH = "yyyy/MM/dd HH:mm:ss";
    public static String FORMAT_LONG_SECNOD = "yyyy/MM/dd";
    public static String FORMAT_LONG_SECNOD_DAY = "MM/dd";
    public static String FORMAT_FULL = "yyyy-MM-dd HH:mm:ss.S";
    public static String FORMAT_SHORT_CN = "yyyy\u5e74MM\u6708dd\u65e5";
    public static String FORMAT_LONG_CN = "yyyy\u5e74MM\u6708dd\u65e5  HH\u65f6mm\u5206ss\u79d2";
    public static String FORMAT_FULL_CN = "yyyy\u5e74MM\u6708dd\u65e5  HH\u65f6mm\u5206ss\u79d2SSS\u6beb\u79d2";
    public static String FORMAT_DATAV = "yyyy/MM/dd HH:mm:ss";
    public static String FORMAT_SHORT_EN = "dd/MM/yyyy";
    public static final String LINK_DISPLAY_DATE_MONTH_SHORT = "yy-MM";
    public static final int ONE_DAY_TO_MS = 86400000;
    public static final int FORMAT_WEEK_CN = 1;
    public static final int FORMAT_WEEK = 0;
    public static final int TIME_MINUTE = 0;
    public static final int TIME_HOUR = 1;
    public static final int TIME_DAY = 2;
    public static final int TIME_WEEK = 3;
    public static final int TIME_MONTH = 4;
    public static final int TIME_QUARTER = 5;
    public static final int TIME_YEAR = 6;
    public static final int WEEK_DAY = 7;
    public static final int TIME_WEEK_FIRST_DAY = 8;
    public static final int TIME_DAY_FULL = 9;
    public static final int TIME_DATE = 10;
    public static final int TIME_MONTH_FULL = 11;
    public static final int TIME_QUARTER_FULL = 12;
    public static final int TIME_YEAR_FULL = 13;

    public static String getDatePattern() {
        return FORMAT_LONG;
    }

    public static String getNow() {
        return DateUtils.format(new Date());
    }

    public static String getNow(String format) {
        return DateUtils.format(new Date(), format);
    }

    public static String format(Date date) {
        return DateUtils.format(date, DateUtils.getDatePattern());
    }

    public static String format(Date date, String pattern) {
        String returnValue = "";
        if (date != null) {
            SimpleDateFormat df = new SimpleDateFormat(pattern);
            returnValue = df.format(date);
        }
        return returnValue;
    }

    public static Date parse(String strDate) {
        return DateUtils.parse(strDate, DateUtils.getDatePattern());
    }

    public static Date getFirstDayOfWeek(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setFirstDayOfWeek(2);
        calendar.setTime(date);
        calendar.set(7, calendar.getFirstDayOfWeek());
        return calendar.getTime();
    }

    public static Date getLastDayOfWeek(Date date) {
        Date d = DateUtils.getFirstDayOfWeek(date);
        return DateUtils.addDay(d, 6);
    }

    public static Date getFirstDayOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(calendar.get(1), calendar.get(2), 1);
        return DateUtils.getStartTimeOfDay(calendar.getTime());
    }

    public static Date getLastDayOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(calendar.get(1), calendar.get(2), calendar.getActualMaximum(5));
        return DateUtils.getEndTimeOfDay(calendar.getTime());
    }

    public static Date parse(String strDate, String pattern) {
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        try {
            return df.parse(strDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date addYear(Date date, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(1, n);
        return cal.getTime();
    }

    public static Date addMonth(Date date, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, n);
        return cal.getTime();
    }

    public static Date addDay(Date date, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, n);
        return cal.getTime();
    }

    public static Date addHour(Date date, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(10, n);
        return cal.getTime();
    }

    public static Date addMinute(Date date, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(12, n);
        return cal.getTime();
    }

    public static Date addSecond(Date date, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(13, n);
        return cal.getTime();
    }

    public static String getTimeString() {
        SimpleDateFormat df = new SimpleDateFormat(FORMAT_FULL);
        Calendar calendar = Calendar.getInstance();
        return df.format(calendar.getTime());
    }

    public static String getYear(Date date) {
        return DateUtils.format(date).substring(0, 4);
    }

    public static int countDays(Date date1, Date date2) {
        int days = (int)((date2.getTime() - date1.getTime()) / 86400000L);
        return days;
    }

    public static int countDays(String date) {
        return DateUtils.countDays(date, DateUtils.getDatePattern());
    }

    public static int countDays(String date, String format) {
        Date t = Calendar.getInstance().getTime();
        Calendar c = Calendar.getInstance();
        c.setTime(DateUtils.parse(date, format));
        Date t1 = c.getTime();
        return DateUtils.countDays(t1, t);
    }

    public static Date getStartTimeOfDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getStartTimeOfDay(String startTime, String pattern) {
        if (!StringUtils.isEmpty((Object)startTime)) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(DateUtils.parse(startTime, pattern));
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            return cal.getTime();
        }
        return null;
    }

    public static String getStartTimeOfDay(Calendar cal) {
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        SimpleDateFormat sdf = new SimpleDateFormat(FORMAT_LONG_SLASH);
        return sdf.format(cal.getTime());
    }

    public static Date getStartOfDay(Calendar cal) {
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getEndTimeOfDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getEndTimeOfDay(String endTime, String pattern) {
        if (!StringUtils.isEmpty((Object)endTime)) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(DateUtils.parse(endTime, pattern));
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 59);
            cal.set(14, 0);
            return cal.getTime();
        }
        return null;
    }

    public static String getEndTimeOfDay(Calendar cal) {
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        SimpleDateFormat sdf = new SimpleDateFormat(FORMAT_LONG_SLASH);
        return sdf.format(cal.getTime());
    }

    public static List<Date> getDateListUntilToday(Date startDate) {
        ArrayList<Date> result = new ArrayList<Date>();
        Date start = DateUtils.getStartTimeOfDay(startDate);
        long startTime = start.getTime();
        int days = DateUtils.countDays(start, new Date());
        for (int i = 0; i < days; ++i) {
            if (i > 0) {
                startTime += 86400000L;
            }
            result.add(new Date(startTime));
        }
        return result;
    }

    public static List<Date> findDates(Date dBegin, Date dEnd) {
        ArrayList<Date> lDate = new ArrayList<Date>();
        lDate.add(dBegin);
        Calendar calBegin = Calendar.getInstance();
        calBegin.setTime(dBegin);
        Calendar calEnd = Calendar.getInstance();
        calEnd.setTime(dEnd);
        while (dEnd.after(calBegin.getTime())) {
            calBegin.add(5, 1);
            lDate.add(calBegin.getTime());
        }
        return lDate;
    }

    public static List<String> findDatesContainStartAndEnd(Date dBegin, Date dEnd, String format) {
        ArrayList<String> lDate = new ArrayList<String>();
        lDate.add(DateUtils.format(dBegin, format));
        Calendar calBegin = Calendar.getInstance();
        calBegin.setTime(dBegin);
        Calendar calEnd = Calendar.getInstance();
        calEnd.setTime(dEnd);
        while (dEnd.after(calBegin.getTime())) {
            calBegin.add(5, 1);
            lDate.add(DateUtils.format(calBegin.getTime(), format));
        }
        return lDate;
    }

    public static String getWeekOfDate(Date dt) {
        return DateUtils.getWeekOfDate(dt, 1);
    }

    public static String getWeekOfDate(Date dt, int type) {
        String[] weekDays = new String[]{"\u661f\u671f\u65e5", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d"};
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        int w = cal.get(7) - 1;
        if (w < 0) {
            w = 0;
        }
        if (type == 1) {
            return weekDays[w];
        }
        return w + "";
    }

    public static int getMonth(Date dt) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        int w = cal.get(2) + 1;
        return w;
    }

    public static String getDayOfMonth(Date dt) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        int w = cal.get(5);
        return w + "";
    }

    public static Date changeStr2StartDate(String time) {
        if (StringUtils.isEmpty((Object)time)) {
            return null;
        }
        return DateUtils.getStartTimeOfDay(DateUtils.changeStr2Date(time));
    }

    public static Date changeStr2EndDate(String time) {
        if (StringUtils.isEmpty((Object)time)) {
            return null;
        }
        return DateUtils.getEndTimeOfDay(DateUtils.changeStr2Date(time));
    }

    public static Date changeStr2Date(String time) {
        if (StringUtils.isEmpty((Object)time)) {
            return null;
        }
        int shortLen = FORMAT_SHORT.length();
        int longLen = FORMAT_LONG.length();
        int noSecondLen = FORMAT_NO_SECNOD.length();
        if (time.length() == shortLen) {
            return DateUtils.parse(time, FORMAT_SHORT);
        }
        if (time.length() == longLen) {
            return DateUtils.parse(time, FORMAT_LONG);
        }
        if (time.length() == noSecondLen) {
            return DateUtils.parse(time, FORMAT_NO_SECNOD);
        }
        if (time.length() == 13) {
            return new Date(Long.valueOf(time));
        }
        return null;
    }

    public static int getQuarterOfYear(Date date) {
        return (DateUtils.getMonth(date) - 1) / 3 + 1;
    }

    public static String getQuarter(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int month = cal.get(2);
        int year = cal.get(1);
        switch (month) {
            case 0: 
            case 1: 
            case 2: {
                return year + "Q1";
            }
            case 3: 
            case 4: 
            case 5: {
                return year + "Q2";
            }
            case 6: 
            case 7: 
            case 8: {
                return year + "Q3";
            }
            case 9: 
            case 10: 
            case 11: {
                return year + "Q4";
            }
        }
        return "";
    }

    public static int getWeekOfYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setFirstDayOfWeek(2);
        calendar.setTime(date);
        int result = calendar.get(3);
        if (result == 1 && date.after(DateUtils.parse(DateUtils.getYear(date) + "-12-01", "yyyy-MM-dd"))) {
            calendar.setTime(DateUtils.addDay(date, -7));
            result = calendar.get(3) + 1;
        }
        return result;
    }

    public static String getDatePeriodByWeekOfYear(int year, int i) {
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(2);
        cal.set(1, year);
        cal.set(3, i);
        SimpleDateFormat sdf = new SimpleDateFormat(FORMAT_SHORT);
        cal.set(7, cal.getFirstDayOfWeek());
        String beginDate = sdf.format(cal.getTime());
        cal.add(7, 6);
        String endDate = sdf.format(cal.getTime());
        return beginDate + "~" + endDate;
    }

    public static Date getYearBeginDate(int year) {
        Calendar cal = Calendar.getInstance();
        cal.set(year, 0, 1, 0, 0, 0);
        SimpleDateFormat sdf = new SimpleDateFormat(FORMAT_SHORT);
        String beginDate = sdf.format(cal.getTime());
        return DateUtils.parse(beginDate, FORMAT_SHORT);
    }

    public static Date getYearEndDate(int year) {
        Calendar cal = Calendar.getInstance();
        cal.set(year, 11, 31, 0, 0, 0);
        SimpleDateFormat sdf = new SimpleDateFormat(FORMAT_SHORT);
        String beginDate = sdf.format(cal.getTime());
        return DateUtils.getEndTimeOfDay(DateUtils.parse(beginDate, FORMAT_SHORT));
    }

    public static Date getBeforeDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, -1);
        date = calendar.getTime();
        return date;
    }

    public static Date getLastMonthFirstDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, -1);
        calendar.set(5, 1);
        return DateUtils.getStartTimeOfDay(calendar.getTime());
    }

    public static Date getLastMonthLastDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int month = calendar.get(2);
        calendar.set(2, month - 1);
        calendar.set(5, calendar.getActualMaximum(5));
        return DateUtils.getEndTimeOfDay(calendar.getTime());
    }

    public static List<String> findAllTimesInTwoDates(String stime, String etime, Integer timeType) {
        ArrayList<String> times = new ArrayList<String>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date startDate = null;
        Date endDate = null;
        try {
            startDate = sdf.parse(stime);
            endDate = sdf.parse(etime);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        if (timeType == 4) {
            startDate = DateUtils.getFirstDayOfMonth(startDate);
        }
        if (timeType == 3) {
            startDate = DateUtils.getFirstDayOfWeek(startDate);
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(startDate);
        while (cal.getTime().before(endDate)) {
            String dateStr = sdf.format(cal.getTime());
            String timeStr = DateUtils.getShowTimeStr(dateStr, timeType);
            times.add(timeStr);
            switch (timeType) {
                case 0: {
                    cal.add(12, 1);
                    break;
                }
                case 1: {
                    cal.add(10, 1);
                    break;
                }
                case 2: 
                case 9: 
                case 10: {
                    cal.add(5, 1);
                    break;
                }
                case 3: 
                case 8: {
                    cal.add(5, 7);
                    break;
                }
                case 4: 
                case 11: {
                    cal.add(2, 1);
                    break;
                }
                case 5: {
                    cal.add(2, 3);
                    break;
                }
                case 6: 
                case 13: {
                    cal.add(1, 1);
                }
            }
        }
        return times;
    }

    public static String getShowTimeStr(String dateStr, int timeType) {
        String output = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = null;
        try {
            date = sdf.parse(dateStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        switch (timeType) {
            case 0: {
                output = dateStr.substring(11, 16);
                break;
            }
            case 1: {
                output = dateStr.substring(11, 16);
                break;
            }
            case 2: {
                output = dateStr.substring(5, 10);
                break;
            }
            case 9: {
                output = dateStr;
                break;
            }
            case 10: {
                output = dateStr.substring(0, 10);
                break;
            }
            case 3: {
                if (cal.get(3) == 1) {
                    output = cal.get(1) + 1 + "\u5e74\u7b2c" + cal.get(3) + "\u5468";
                    break;
                }
                output = cal.get(1) + "\u5e74\u7b2c" + cal.get(3) + "\u5468";
                break;
            }
            case 4: {
                int month = cal.get(2) + 1;
                String year = cal.get(1) + "";
                String monthStr = month < 10 ? "0" + month : "" + month;
                output = year.substring(2, year.length()) + "-" + monthStr;
                break;
            }
            case 11: {
                output = DateUtils.format(DateUtils.getFirstDayOfMonth(date), FORMAT_LONG);
                break;
            }
            case 5: {
                output = cal.get(1) + "\u5e74\u7b2c" + (cal.get(2) / 3 + 1) + "\u5b63\u5ea6";
                break;
            }
            case 6: {
                output = cal.get(1) + "";
                break;
            }
            case 13: {
                output = cal.get(1) + "";
                break;
            }
            case 8: {
                output = DateUtils.format(DateUtils.getFirstDayOfWeek(cal.getTime()), FORMAT_SHORT);
                break;
            }
            default: {
                output = dateStr.substring(11, 16);
            }
        }
        return output;
    }

    public static long getTimeDif(Date stime, Date etime) {
        return stime.getTime() - etime.getTime();
    }

    public static Date getNextDayWorkTime(Date time) {
        Calendar c = Calendar.getInstance();
        c.setTime(time);
        c.add(5, 1);
        return DateUtils.parse(DateUtils.format(c.getTime(), FORMAT_SHORT) + " 08:30:00");
    }

    public static void main(String[] args) {
    }
}

