/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.boot.utils.security;

import com.ovopark.boot.utils.lang.ConvertUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;

public class SignUtils {
    public static final String sign_method_MD5 = "md5";
    public static final String sign_method_SHA = "sha1";
    public static final String signature = "_sig";
    public static final String _SM = "_sm";
    public static final String _SIG = "_sig";
    private static String debugInfo = "";

    public static String sign(Map<String, Object> paramValues, String sign, String sign_method) {
        return SignUtils.sign(paramValues, null, sign, sign_method);
    }

    public static String sign(Map<String, Object> paramValues, List<String> ignoreParamNames, String secret, String sign_method) {
        try {
            StringBuilder sb = new StringBuilder();
            ArrayList<String> paramNames = new ArrayList<String>(paramValues.size());
            paramNames.addAll(paramValues.keySet());
            if (ignoreParamNames != null && ignoreParamNames.size() > 0) {
                for (String ignoreParamName : ignoreParamNames) {
                    paramNames.remove(ignoreParamName);
                }
            }
            Collections.sort(paramNames);
            sb.append(secret);
            for (String paramName : paramNames) {
                String value = ConvertUtils.toStr(paramValues.get(paramName), "");
                sb.append(paramName).append(value);
            }
            sb.append(secret);
            debugInfo = sb.toString();
            byte[] digests = null;
            sign_method = sign_method.toLowerCase();
            digests = sign_method_MD5.equals(sign_method) ? SignUtils.getMD5Digest(sb.toString()) : SignUtils.getSHA1Digest(sb.toString());
            return SignUtils.byte2hex(digests);
        }
        catch (IOException e) {
            throw new RuntimeException("apigetway sign error:" + e.getMessage());
        }
    }

    public static String utf8Encoding(String value, String sourceCharsetName) {
        try {
            return new String(value.getBytes(sourceCharsetName), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static byte[] getSHA1Digest(String data) throws IOException {
        byte[] bytes = null;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            bytes = md.digest(data.getBytes("UTF-8"));
        }
        catch (GeneralSecurityException gse) {
            throw new IOException(gse);
        }
        return bytes;
    }

    private static byte[] getMD5Digest(String data) throws IOException {
        byte[] bytes = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            bytes = md.digest(data.getBytes("UTF-8"));
        }
        catch (GeneralSecurityException gse) {
            throw new IOException(gse);
        }
        return bytes;
    }

    private static String byte2hex(byte[] bytes) {
        StringBuilder sign = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            String hex = Integer.toHexString(bytes[i] & 0xFF);
            if (hex.length() == 1) {
                sign.append("0");
            }
            sign.append(hex.toUpperCase());
        }
        return sign.toString();
    }

    public static String getUUID() {
        UUID uuid = UUID.randomUUID();
        return uuid.toString().toUpperCase();
    }

    public static boolean checkSign(String sign, String applicationSecret, String signatureMethod, HttpServletRequest request) {
        HashMap<String, Object> needSignParams = new HashMap<String, Object>();
        Enumeration enume = request.getParameterNames();
        while (enume.hasMoreElements()) {
            String name = ((String)enume.nextElement()).toString();
            if (name.equals("_sig")) continue;
            String value = ConvertUtils.toStr(request.getParameter(name), "");
            needSignParams.put(name, value);
        }
        String signValue = SignUtils.sign(needSignParams, applicationSecret, signatureMethod);
        return signValue.equals(sign);
    }

    public static String sign(String sign_method, String parmsvalue) {
        try {
            byte[] digests = null;
            sign_method = sign_method.toLowerCase();
            digests = sign_method_MD5.equals(sign_method) ? SignUtils.getMD5Digest(parmsvalue) : SignUtils.getSHA1Digest(parmsvalue);
            return SignUtils.byte2hex(digests);
        }
        catch (IOException e) {
            throw new RuntimeException("apigetway sign error:" + e.getMessage());
        }
    }

    public static String getDebugInfo() {
        return debugInfo;
    }
}

