/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.boot.utils.validate;

import java.util.Iterator;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Valid;
import javax.validation.Validation;
import javax.validation.Validator;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;
import org.springframework.util.StringUtils;

public class ConditionalParamValidateUtils {
    private static Validator validatorFast = ((HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure()).failFast(true).buildValidatorFactory().getValidator();
    private static Validator validatorAll = ((HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure()).failFast(false).buildValidatorFactory().getValidator();

    public static <T> Set<ConstraintViolation<T>> validateFast(@Valid T domain) throws Exception {
        return ConditionalParamValidateUtils.validateFast(domain, false);
    }

    public static <T> Set<ConstraintViolation<T>> validateFast(@Valid T domain, boolean showValidField) throws Exception {
        Set validateResult = validatorFast.validate(domain, new Class[0]);
        if (validateResult.size() > 0) {
            String validResultStr = ((ConstraintViolation)validateResult.iterator().next()).getMessage();
            if (showValidField) {
                validResultStr = "[ " + ((ConstraintViolation)validateResult.iterator().next()).getPropertyPath() + " ] " + validResultStr;
            }
            throw new IllegalArgumentException(validResultStr);
        }
        return validateResult;
    }

    public static <T> Set<ConstraintViolation<T>> validateAll(@Valid T domain) throws Exception {
        return ConditionalParamValidateUtils.validateAll(domain, false);
    }

    public static <T> Set<ConstraintViolation<T>> validateAll(@Valid T domain, boolean showValidField) throws Exception {
        Set validateResult = validatorAll.validate(domain, new Class[0]);
        if (validateResult.size() > 0) {
            Iterator it = validateResult.iterator();
            StringBuilder stringBuilder = new StringBuilder();
            while (it.hasNext()) {
                ConstraintViolation cv = (ConstraintViolation)it.next();
                String res = cv.getMessage();
                if (showValidField) {
                    res = "[ " + cv.getPropertyPath() + " ] " + cv.getMessage();
                }
                if (StringUtils.hasText((CharSequence)stringBuilder)) {
                    stringBuilder.append(", " + res);
                    continue;
                }
                stringBuilder.append(res);
            }
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        return validateResult;
    }
}

