package com.ovopark.boot.plugin.xml;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
/**
 * @ClassName:  JacksonXmlKit   
 * @Description:TODO(jackson xml工具类)   
 * @author: Remiel_Mercy 
 * @date:   2021年1月6日 下午4:20:12   
 *     
 * @Copyright: 2021 www.ovopark.com Inc. All rights reserved.
 */
public class JacksonXmlKit {
	private static ObjectMapper xmlMapper = new XmlMapper();
	static {
		//反序列化时，若实体类没有对应的属性，是否抛出JsonMappingException异常，false忽略掉
		xmlMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false); 
		//序列化是否绕根元素，true，则以类名为根元素
		xmlMapper.configure(SerializationFeature.WRAP_ROOT_VALUE, false);
		//忽略空属性
		xmlMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
		//XML标签名:使用骆驼命名的属性名
		xmlMapper.setPropertyNamingStrategy(PropertyNamingStrategy.UPPER_CAMEL_CASE);
		//设置转换模式
		xmlMapper.enable(MapperFeature.USE_STD_BEAN_NAMING);
	}
	
	public static <T> String objToJson(T obj) {
		if (obj == null) {
			return null;
		}
		try {
			return obj instanceof String ? (String) obj : xmlMapper.writeValueAsString(obj);
		} catch (Exception e) {
			return null;
		}
	}
}
