package com.ovopark.boot.business.analysis.god.target.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 
 * </p>
 *
 * @author xuxing
 * @since 2019-11-21
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Application implements Serializable {

    private static final long serialVersionUID = 1L;
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 应用名称
     */
    private String name;

    /**
     * 应用类型
     */
    private Integer type;

    /**
     * 应用地址
     */
    private String appUrl;

    /**
     * 应用描述
     */
    private String appDesc;

    /**
     * 应用图标URL
     */
    private String iconUrl;

    /**
     * 是否有效 1 有效 0 无效
     */
    private Boolean isEffective;

    /**
     * 是否公开 1 公开 0 不公开
     */
    private Boolean isPublic;

    /**
     * 是否私有部署 1 私有 0 公有
     */
    private Boolean isPrivateDeploy;

    /**
     * 是否删除
     */
    private Boolean isDeleted;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime upgradeTime;

    /**
     * 创建人
     */
    private Integer createUser;

    /**
     * 备注
     */
    private String remark;


}
