package com.ovopark.boot.business.analysis.god.target.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;

/**
 * <p>
 * 
 * </p>
 *
 * @author liushuai
 * @since 2019-06-18
 */
@TableName("target_total_data_sale_month")
public class SaleMonth implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 产品线类别（1：PC4，2：FR3，3：营销，4：巡店）
     */
    private Integer productType;

    /**
     * 销量（按月统计）
     */
    private Integer saleNums;

    /**
     * 销售收入（按月统计）
     */
    private Double saleIncome;

    /**
     * 统计时间YYYY-MM格式
     */
    private LocalDate createTime;

    /**
     * 销售区域
     */
    private String saleArea;

    /**
     * 同步时间
     */
    private LocalDateTime syncTime;


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getProductType() {
        return productType;
    }

    public void setProductType(Integer productType) {
        this.productType = productType;
    }

    public Integer getSaleNums() {
        return saleNums;
    }

    public void setSaleNums(Integer saleNums) {
        this.saleNums = saleNums;
    }

    public Double getSaleIncome() {
        return saleIncome;
    }

    public void setSaleIncome(Double saleIncome) {
        this.saleIncome = saleIncome;
    }

    public LocalDate getCreateTime() {
        return createTime;
    }

    public void setCreateTime(LocalDate createTime) {
        this.createTime = createTime;
    }

    public String getSaleArea() {
        return saleArea;
    }

    public void setSaleArea(String saleArea) {
        this.saleArea = saleArea;
    }

    public LocalDateTime getSyncTime() {
        return syncTime;
    }

    public void setSyncTime(LocalDateTime syncTime) {
        this.syncTime = syncTime;
    }

    @Override
    public String toString() {
        return "TargetTotalDataSaleMonth{" +
        "id=" + id +
        ", productType=" + productType +
        ", saleNums=" + saleNums +
        ", saleIncome=" + saleIncome +
        ", createTime=" + createTime +
        ", saleArea=" + saleArea +
        ", syncTime=" + syncTime +
        "}";
    }
}
