package com.ovopark.boot.business.analysis.god.target.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.io.Serializable;

/**
 * <p>
 * 
 * </p>
 *
 * @author liushuai
 * @since 2019-06-18
 */
@TableName("target_total_data_sale_year")
public class SaleYear implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 产品线类别（1：PC4，2：FR3，3：营销，4：巡店）
     */
    private Integer productType;

    /**
     * 年销量目标
     */
    private Integer yearNumsTarget;

    /**
     * 年收入目标
     */
    private Double yearIncomeTarget;

    /**
     * 销量（按年统计）
     */
    private Integer saleNums;

    /**
     * 销售收入（按年统计）
     */
    private Double saleIncome;

    /**
     * 统计时间YYYY格式
     */
    private LocalDate createTime;

    /**
     * 同步时间
     */
    private LocalDateTime syncTime;


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getProductType() {
        return productType;
    }

    public void setProductType(Integer productType) {
        this.productType = productType;
    }

    public Integer getYearNumsTarget() {
        return yearNumsTarget;
    }

    public void setYearNumsTarget(Integer yearNumsTarget) {
        this.yearNumsTarget = yearNumsTarget;
    }

    public Double getYearIncomeTarget() {
        return yearIncomeTarget;
    }

    public void setYearIncomeTarget(Double yearIncomeTarget) {
        this.yearIncomeTarget = yearIncomeTarget;
    }

    public Integer getSaleNums() {
        return saleNums;
    }

    public void setSaleNums(Integer saleNums) {
        this.saleNums = saleNums;
    }

    public Double getSaleIncome() {
        return saleIncome;
    }

    public void setSaleIncome(Double saleIncome) {
        this.saleIncome = saleIncome;
    }

    public LocalDate getCreateTime() {
        return createTime;
    }

    public void setCreateTime(LocalDate createTime) {
        this.createTime = createTime;
    }

    public LocalDateTime getSyncTime() {
        return syncTime;
    }

    public void setSyncTime(LocalDateTime syncTime) {
        this.syncTime = syncTime;
    }

    @Override
    public String toString() {
        return "SaleYear{" +
                "id=" + id +
                ", productType=" + productType +
                ", yearNumsTarget=" + yearNumsTarget +
                ", yearIncomeTarget=" + yearIncomeTarget +
                ", saleNums=" + saleNums +
                ", saleIncome=" + saleIncome +
                ", createTime=" + createTime +
                ", syncTime=" + syncTime +
                '}';
    }
}
