package com.ovopark.boot.business.analysis.god.target.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 
 * </p>
 *
 * @author xuxing
 * @since 2019-11-21
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("application_user_apply")
public class UserApply implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 申请应用ID
     */
    private Long appId;

    /**
     * 应用名称
     */
    private String appName;

    /**
     * 企业ID
     */
    private Integer groupId;

    /**
     * 企业名称
     */
    private String groupName;

    /**
     * 0 未申请 1 审核中 2 审核通过 3 审核驳回
     */
    private Integer status;

    /**
     * 申请备注
     */
    private String applyRemark;

    /**
     * 申请时间
     */
    private LocalDateTime applyTime;

    /**
     * 申请人ID
     */
    private Integer applyUser;

    /**
     * 申请人名
     */
    private String applyUserName;

    /**
     * 审核时间
     */
    private LocalDateTime auditTime;

    /**
     * 审核人ID
     */
    private Integer auditUser;

    /**
     * 审核人名
     */
    private String auditUserName;

    /**
     * 备注（驳回原因）
     */
    private String remark;


}
