package com.ovopark.boot.business.analysis.god.target.entity.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * 公共属性(初始化加载一次即可)
 * Created by xuxing on 2019/11/28
 */
@Data
@Accessors(chain = true)
public class CommonModel implements Serializable {

  /**
   * 用户访问ip TODO 批量可能发生变化
   */
  private String ip;

  /**
   * 用户的唯一标识
   */
  private String distinct_id;

  /**
   * 用户id
   */
  private Integer user_id = 0;

  /**
   * 用户名
   */
  private String user_name;

  /**
   * 企业id
   */
  private Integer enterprise_id = 0;

  /**
   * 企业名
   */
  private String enterprise_name;

  /**
   * 类型（安卓、iOS、web、其他等）
   */
  private Integer type;

  /**
   * app 版本
   */
  private String app_version;

  /**
   * SDK类型，例如python、iOS等
   */
  private String lib;
  /**
   * SDK版本
   */
  private String lib_version;
  /**
   * 设备制造商
   */
  private String manufacturer;
  /**
   * 设备型号
   */
  private String model;
  /**
   * 操作系统
   */
  private String os;
  /**
   * 操作系统版本
   */
  private String os_version;
  /**
   * 屏幕高度
   */
  private Integer screen_height;
  /**
   * 屏幕宽度
   */
  private Integer screen_width;
  /**
   * 浏览器名
   */
  private String browser;
  /**
   * 浏览器版本
   */
  private String browser_version;
  /**
   * 运营商名称 TODO 双卡，最好和事件一起提供，如果事件当中取不到取该值
   */
  private String carrier;
  /**
   * 网络类型，TODO 可能每个事件不一样，最好和事件一起提供
   */
  private String network_type;

  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private Date create_time;

  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private Date syncTime;

  /**
   * 如果用户信息为空，需要解析此token,获取用户信息
   */
  private String token;

  private Integer role = 0;

  /**
   * 应用Id,与应用配置关联起来
   */
  private Integer application_id;
}
