package com.ovopark.boot.business.analysis.god.target.entity.model;

import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * Created by xuxing on 2018/12/10
 */
@Data
@Accessors(chain = true)
public class EsModel implements Serializable {

  /**
   * index 相当于库
   */
  private String index;

  /**
   * type 相当于表
   */
  private String type;

  /**
   * id 相当于主键id
   */
  private String id;

  /**
   * doc 数据 json 类型
   */
  private String doc;

  /**
   * 查询需要返回的字段 英文逗号分隔
   * 不传默认返回所有
   */
  private String fields;

  /**
   * 需要查询的字段,多字段用&分隔 ，一个字段多条件用英文逗号分隔（使用精确查询，不做拼音、分词处理），查询字段与条件用等号分隔
   * 注意：如果查询条件以英文下划线开头会使用分词器
   * 方式1 _A=1&B=2,3 （A是不区分中英文拼音不可多参数，只能一对一，B 则不做约束,精确查询)</p>
   * 方式2 ：A=1,2,3&B=2,4  （此方式不做中英文拼音处理，做精确查询)
   */
  private String matchFields;

  /**
   * 起始值
   */
  private Integer start;

  /**
   * 查询数目
   */
  private Integer size;

  /**
   * 查询范围字段名，时刻数值类型
   */
  private String rangeField;

  /**
   * 查询范围起始
   */
  private Object rangeFrom;

  /**
   * 查询范围结束
   */
  private Object rangeTo;

  /**
   * 查询范围字段名，时间类型
   */
  private String rangeTimeField;

  /**
   * 查询时间范围起始
   */
  @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
  private Date rangeTimeFrom;

  /**
   * 查询时间范围结束
   */
  @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
  private Date rangeTimeTo;

  private String rangeTimeFromStr;

  /**
   * 查询时间范围结束
   */
  private String rangeTimeToStr;

  /**
   * 排序字段
   */
  private String sortField;

  /**
   * 排序类型 asc desc
   */
  private String sortType;

  private List<EsModel> docs;

  /**
   * 分词器类型
   * 1、ik_smart （智能分词）
   * 2、ik_max_word （最大程度分词）
   * 3、pin_yin （拼音分词器）
   * 4、standard (标准分词器)
   * 5、keyword (精确查询，默认就是)
   */
  private String tokenizerType;

  /**
   * 匹配类型
   *
   * 1、matchQuery
   * 2、termQuery
   * 3、matchPhraseQuery
   * 4、matchAllQuery
   * 5、boolQuery
   * 6、fuzzyQuery
   * 7、prefixQuery
   * 8、wrapperQuery
   *
   */
  private  String matchType;

  /**
   * 根据sql 语句查询
   */
  private String sql;

  /**
   * 按照时间分组字段
   * 去重时间字段
   */
  private String groupByTimeField;

  /**
   * 时间去重格式
   * day ,week ,month,year
   */
  private String groupByTimeType;

  /**
   * 去重字段
   */
  private String groupByField;

  /**
   * 统计字段
   * 格式如下
   * age=key1-to,key2-from2-to2,key3-from3,to3,key4,froom4
   *
   * 按照范围统计
   */
  private String countRange;

  /**
   * 按照字段统计,与countRange 只能存在一个
   * 格式 regType
   */
  private String termsAggField;

  /**
   * 脚本
   */
  private String termsScript;

  /**
   * 取平均数字段
   */
  private String avgField;

  /**
   * 取最大值，英文逗号分隔
   */
  private String maxField;

}
