package com.ovopark.boot.business.analysis.god.target.entity.vo;

import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author xuxing
 * @since 2019-11-21
 */
@Data
@Accessors(chain = true)
public class ApplicationVo extends BaseVo {

  private Long id;

  /**
   * 应用名称
   */
  private String name;

  /**
   * 应用类型 1、2、3、4
   */
  private Integer type;

  /**
   * 应用描述
   */
  private String appDesc;

  /**
   * 应用地址
   */
  private String appUrl;

  /**
   * 应用图标URL
   */
  private String iconUrl;

  /**
   * 是否有效 1 有效 0 无效
   */
  private Boolean isEffective;

  /**
   * 是否公开 1 公开 0 不公开
   */
  private Boolean isPublic;

  /**
   * 是否私有部署 1 私有 0 公有
   */
  private Boolean isPrivateDeploy;

  /**
   * 创建时间
   */
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 更新时间
   */
  private LocalDateTime upgradeTime;

  /**
   * 创建人
   */
  private Integer createUser;

  /**
   * 备注
   */
  private String remark;


  /**
   * 当前用户的状态 0 未申请 1 申请中 2 申请成功 3 申请驳回
   */
  private Integer status;

  private Boolean isDeleted;

  private List<Integer> types;

  /**
   * 开放的企业
   */
  private List<OpenEnterpriseVo> openEnterprises;

  /**
   * 格式 yyyy-MM-dd hh:mm:ss
   */
  private String stime;

  private String etime;

  private String eventCode;

  /**
   * 企业名称
   */
  private String enterpriseName;
  /**
   * 申请人名
   */
  private String userName;

  /**
   * 多日期用逗号分隔
   */
  private String dayTime;

  private String timeType;

}
