package com.ovopark.boot.business.analysis.god.target.entity.vo;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

/**
 * Created by xuxing on 2019/6/20
 */
public class BaseDataVo implements Serializable {
  private static final long serialVersionUID = -6203357858698714330L;

  /**
   * 年销量目标
   */
  private Integer yearNumsTarget;

  /**
   * 年收入目标
   */
  private Double yearIncomeTarge;

  /**
   * 销量（年实际销量）
   */
  private Integer saleNums;

  /**
   * 销售收入(年实际收入)
   */
  private Double saleIncome;

  /**
   * 销量目标达成率
   */
  private Double numsTargetProgress;

  /**
   * 目标达成率（收入）
   */
  private Double incomeTargetProgress;

  /**
   * 近一月设备在线率
   */
  private Double latestMonthAverageOnlineRate;

  /**
   * 本月销量
   */
  private Integer currentSaleNums;

  /**
   * 销量横坐标日期
   */
  private String[] lineChartAxis;

  /**
   * 横坐标对应销量数据
   */
  private Integer[] lineChartNumsData;

  /**
   * 横坐标对应收入数据
   */
  private Double[] lineChartIncomeData;

  /**
   * 饼图数据
   */
  private List<DataVo> barChartData;

  public Integer getYearNumsTarget() {
    return yearNumsTarget;
  }

  public void setYearNumsTarget(Integer yearNumsTarget) {
    this.yearNumsTarget = yearNumsTarget;
  }

  public Double getYearIncomeTarge() {
    return yearIncomeTarge;
  }

  public void setYearIncomeTarge(Double yearIncomeTarge) {
    this.yearIncomeTarge = yearIncomeTarge;
  }

  public Integer getSaleNums() {
    return saleNums;
  }

  public void setSaleNums(Integer saleNums) {
    this.saleNums = saleNums;
  }

  public Double getSaleIncome() {
    return saleIncome;
  }

  public void setSaleIncome(Double saleIncome) {
    this.saleIncome = saleIncome;
  }

  public Double getNumsTargetProgress() {
    return numsTargetProgress;
  }

  public void setNumsTargetProgress(Double numsTargetProgress) {
    this.numsTargetProgress = numsTargetProgress;
  }

  public Double getIncomeTargetProgress() {
    return incomeTargetProgress;
  }

  public void setIncomeTargetProgress(Double incomeTargetProgress) {
    this.incomeTargetProgress = incomeTargetProgress;
  }

  public Double getLatestMonthAverageOnlineRate() {
    return latestMonthAverageOnlineRate;
  }

  public void setLatestMonthAverageOnlineRate(Double latestMonthAverageOnlineRate) {
    this.latestMonthAverageOnlineRate = latestMonthAverageOnlineRate;
  }

  public Integer getCurrentSaleNums() {
    return currentSaleNums;
  }

  public void setCurrentSaleNums(Integer currentSaleNums) {
    this.currentSaleNums = currentSaleNums;
  }

  public String[] getLineChartAxis() {
    return lineChartAxis;
  }

  public void setLineChartAxis(String[] lineChartAxis) {
    this.lineChartAxis = lineChartAxis;
  }

  public Integer[] getLineChartNumsData() {
    return lineChartNumsData;
  }

  public void setLineChartNumsData(Integer[] lineChartNumsData) {
    this.lineChartNumsData = lineChartNumsData;
  }

  public Double[] getLineChartIncomeData() {
    return lineChartIncomeData;
  }

  public void setLineChartIncomeData(Double[] lineChartIncomeData) {
    this.lineChartIncomeData = lineChartIncomeData;
  }

  public List<DataVo> getBarChartData() {
    return barChartData;
  }

  public void setBarChartData(List<DataVo> barChartData) {
    this.barChartData = barChartData;
  }

  @Override
  public String toString() {
    return "BaseDataVo{" +
            "yearNumsTarget=" + yearNumsTarget +
            ", yearIncomeTarge=" + yearIncomeTarge +
            ", saleNums=" + saleNums +
            ", saleIncome=" + saleIncome +
            ", numsTargetProgress=" + numsTargetProgress +
            ", incomeTargetProgress=" + incomeTargetProgress +
            ", latestMonthAverageOnlineRate=" + latestMonthAverageOnlineRate +
            ", currentSaleNums=" + currentSaleNums +
            ", lineChartAxis=" + Arrays.toString(lineChartAxis) +
            ", lineChartNumsData=" + Arrays.toString(lineChartNumsData) +
            ", lineChartIncomeData=" + Arrays.toString(lineChartIncomeData) +
            ", barChartData=" + barChartData +
            '}';
  }
}
