package com.ovopark.boot.business.analysis.god.target.entity.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author xuxing
 * @since 2019-11-21
 */
@Data
@Accessors(chain = true)
public class EventVo extends BaseVo {

  private static final long serialVersionUID = 1L;

  private Long id;
  /**
   * 事件代码
   */
  private String eventCode;

  /**
   * 事件名
   */
  private String eventName;

  /**
   * 事件说明
   */
  private String eventDesc;

  /**
   * 创建人ID
   */
  private Integer createUser;

  /**
   * 创建人名
   */
  private String createUserName;

  /**
   *  0 删除,1 有效 2无效
   */
  private Integer status;

  /**
   * 创建时间
   */
  @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private LocalDateTime createTime;

  /**
   * 备注
   */
  private String remark;

  /**
   * 属性
   */
  private List<EventAttributeVo> attributes;


}
