package com.ovopark.boot.business.analysis.god.target.entity.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 
 * </p>
 *
 * @author xuxing
 * @since 2019-11-21
 */
@Data
@Accessors(chain = true)
public class UserApplyVo extends BaseVo {

    private static final long serialVersionUID = 1L;

    private Long id;

    /**
     * 申请应用ID
     */
    private Long appId;

    /**
     * 应用名称
     */
    private String appName;

    /**
     * 企业ID
     */
    private Integer groupId;

    /**
     * 企业名称
     */
    private String groupName;

    /**
     * 0 未申请 1 审核中 2 审核通过 3 审核驳回
     */
    private Integer status;

    /**
     * 申请备注
     */
    private String applyRemark;

    /**
     * 申请时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime applyTime;

    /**
     * 申请人ID
     */
    private Integer applyUser;

    /**
     * 申请人名
     */
    private String applyUserName;

    /**
     * 审核时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime auditTime;

    /**
     * 审核人ID
     */
    private Integer auditUser;

    /**
     * 审核人名
     */
    private String auditUserName;

    /**
     * 备注（驳回原因）
     */
    private String remark;

    private List<Integer> statusList;

    private List<Long> ids;
}
