package com.ovopark.boot.business.analysis.god.target.entity.vo;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * @author 刘帅
 * @ClassName
 * @Description 活跃用户和新增用户数据
 * @Date 2019/7/5 10:21
 * @Version 1.0
 **/
public class UserDataVo implements Serializable {
    private static final long serialVersionUID = -5579601097699142121L;

    /**
     * 活跃用户数分布
     */
    private List<Map<String,Object>> distributeDAU;

    /**
     * 活跃企业分布
     */
    private List<Map<String,Object>> distributeDAE;

    /**
     * 累积用户数
     */
    private Integer allUserCount;

    /**
     * 新增用户数
     */
    private Integer newUser;

    /**
     * 新增用户数环比
     */
    private double newUserRate;

    /**
     * 活跃用户数
     */
    private Integer activityUser;

    /**
     * 活跃用户数环比
     */
    private double activityUserRate;

    /**
     * 启动次数
     */
    private Integer operationCounts;

    /**
     * 启动次数环比
     */
    private double operationCountsRate;
    /**
     * 人均启动次数
     */
    private Integer operationCountsPer;
    /**
     * 人均启动次数环比
     */
    private double operationCountsPerRate;

    /**
     * 人均停留时长（单位：秒）
     */
    private Integer stayLengthPer;
    /**
     * 人均停留时长环比
     */
    private double stayLengthPerRate;

    /**
     * 横坐标日期
     */
    private String[] lineChartAxis;

    /**
     * 横坐标对应数据
     */
    private Integer[] lineChartNumsData;

    public List<Map<String, Object>> getDistributeDAU() {
        return distributeDAU;
    }

    public void setDistributeDAU(List<Map<String, Object>> distributeDAU) {
        this.distributeDAU = distributeDAU;
    }

    public List<Map<String, Object>> getDistributeDAE() {
        return distributeDAE;
    }

    public void setDistributeDAE(List<Map<String, Object>> distributeDAE) {
        this.distributeDAE = distributeDAE;
    }

    public Integer getNewUser() {
        return newUser;
    }

    public void setNewUser(Integer newUser) {
        this.newUser = newUser;
    }

    public double getNewUserRate() {
        return newUserRate;
    }

    public void setNewUserRate(double newUserRate) {
        this.newUserRate = newUserRate;
    }

    public Integer getActivityUser() {
        return activityUser;
    }

    public void setActivityUser(Integer activityUser) {
        this.activityUser = activityUser;
    }

    public double getActivityUserRate() {
        return activityUserRate;
    }

    public void setActivityUserRate(double activityUserRate) {
        this.activityUserRate = activityUserRate;
    }

    public Integer getOperationCounts() {
        return operationCounts;
    }

    public void setOperationCounts(Integer operationCounts) {
        this.operationCounts = operationCounts;
    }

    public Integer getOperationCountsPer() {
        return operationCountsPer;
    }

    public void setOperationCountsPer(Integer operationCountsPer) {
        this.operationCountsPer = operationCountsPer;
    }

    public Integer getStayLengthPer() {
        return stayLengthPer;
    }

    public void setStayLengthPer(Integer stayLengthPer) {
        this.stayLengthPer = stayLengthPer;
    }

    public String[] getLineChartAxis() {
        return lineChartAxis;
    }

    public void setLineChartAxis(String[] lineChartAxis) {
        this.lineChartAxis = lineChartAxis;
    }

    public Integer[] getLineChartNumsData() {
        return lineChartNumsData;
    }

    public void setLineChartNumsData(Integer[] lineChartNumsData) {
        this.lineChartNumsData = lineChartNumsData;
    }

    public Integer getAllUserCount() {
        return allUserCount;
    }

    public void setAllUserCount(Integer allUserCount) {
        this.allUserCount = allUserCount;
    }

    public double getOperationCountsRate() {
        return operationCountsRate;
    }

    public void setOperationCountsRate(double operationCountsRate) {
        this.operationCountsRate = operationCountsRate;
    }

    public double getOperationCountsPerRate() {
        return operationCountsPerRate;
    }

    public void setOperationCountsPerRate(double operationCountsPerRate) {
        this.operationCountsPerRate = operationCountsPerRate;
    }

    public double getStayLengthPerRate() {
        return stayLengthPerRate;
    }

    public void setStayLengthPerRate(double stayLengthPerRate) {
        this.stayLengthPerRate = stayLengthPerRate;
    }

    @Override
    public String toString() {
        return "UserDataVo{" +
                "distributeDAU=" + distributeDAU +
                ", distributeDAE=" + distributeDAE +
                ", allUserCount=" + allUserCount +
                ", newUser=" + newUser +
                ", newUserRate=" + newUserRate +
                ", activityUser=" + activityUser +
                ", activityUserRate=" + activityUserRate +
                ", operationCounts=" + operationCounts +
                ", operationCountsPer=" + operationCountsPer +
                ", stayLengthPer=" + stayLengthPer +
                ", lineChartAxis=" + Arrays.toString(lineChartAxis) +
                ", lineChartNumsData=" + Arrays.toString(lineChartNumsData) +
                '}';
    }
}
