package com.ovopark.boot.business.analysis.god.target.service;

import com.ovopark.boot.business.analysis.god.target.entity.vo.UserDataVo;

/**
 * @author 刘帅
 * @ClassName
 * @Description 活跃用户和新增用户
 * @Date 2019/7/5 10:15
 * @Version 1.0
 **/
public interface UserDataService {

    /**
     * 获取活跃用户和新增用户的数据
     * @param client
     *          客户端：Android,iOS,web,all
     * @return
     */
    public UserDataVo allUserDataByClient(String client);

    /**
     获取曲线图数据
     * @param client
     *          客户端：Android,iOS,web,all
     * @param targetType
     *          目标类别：1:新增用户数，2:活跃用户数，3:启动次数，4:人均启动次数，5:人均停留时长
     * @param timeType
     *          时间类别：1:7天,按天显示，2: 30天：横坐标显示本日与前29天（以日为单位，30个刻度）
     *          3:3个月，以周为单位，4:6个月,以月为单位
     * @return
     */
    public UserDataVo getUserLineData(String client,Integer targetType,Integer timeType);
}
