package com.ovopark.boot.business.analysis.shopweb.entity;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;

/**
 * <p>
 * 合同产品关联表(产品价格会波动，故记录当时合同成交时候的价格)
 * </p>
 *
 * @author liushuai
 * @since 2019-06-17
 */
@TableName("crm_shenpi_contract_product")
public class ContractProduct implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 合同id
     */
    private Long contractId;

    /**
     * 产品id
     */
    private Long productId;

    /**
     * 顶级分类
     */
    private Long topType;

    /**
     * 一级分类
     */
    private Long firstType;

    /**
     * 2级分类
     */
    private Long sencondType;

    /**
     * 产品名称
     */
    private String productName;

    /**
     * 品牌
     */
    private String brand;

    /**
     * 规格/描述
     */
    private String spec;

    private String description;

    /**
     * 数量
     */
    private Integer nums;

    /**
     * 年
     */
    private Float years;

    /**
     * 原价
     */
    private BigDecimal unitPrice;

    /**
     * 单位（关联数据字典product_unit）
     */
    private String unit;

    /**
     * unit对应的属性(元/年/店：120/1/1)
     */
    private String unitCount;

    /**
     * 销售单价
     */
    private BigDecimal salePrice;

    /**
     * 折扣=销售单价/原价
     */
    private BigDecimal discount;

    /**
     * 折后价（销售报价*数量）
     */
    private BigDecimal discountPrice;

    /**
     * 备注
     */
    private String remark;


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public Long getProductId() {
        return productId;
    }

    public void setProductId(Long productId) {
        this.productId = productId;
    }

    public Long getTopType() {
        return topType;
    }

    public void setTopType(Long topType) {
        this.topType = topType;
    }

    public Long getFirstType() {
        return firstType;
    }

    public void setFirstType(Long firstType) {
        this.firstType = firstType;
    }

    public Long getSencondType() {
        return sencondType;
    }

    public void setSencondType(Long sencondType) {
        this.sencondType = sencondType;
    }

    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getBrand() {
        return brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integer getNums() {
        return nums;
    }

    public void setNums(Integer nums) {
        this.nums = nums;
    }

    public Float getYears() {
        return years;
    }

    public void setYears(Float years) {
        this.years = years;
    }

    public BigDecimal getUnitPrice() {
        return unitPrice;
    }

    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String getUnitCount() {
        return unitCount;
    }

    public void setUnitCount(String unitCount) {
        this.unitCount = unitCount;
    }

    public BigDecimal getSalePrice() {
        return salePrice;
    }

    public void setSalePrice(BigDecimal salePrice) {
        this.salePrice = salePrice;
    }

    public BigDecimal getDiscount() {
        return discount;
    }

    public void setDiscount(BigDecimal discount) {
        this.discount = discount;
    }

    public BigDecimal getDiscountPrice() {
        return discountPrice;
    }

    public void setDiscountPrice(BigDecimal discountPrice) {
        this.discountPrice = discountPrice;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

}
