package com.ovopark.boot.business.analysis.shopweb.entity;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;

/**
 * <p>
 * 
 * </p>
 *
 * @author Remiel_Mercy
 * @since 2019-06-21
 */
@TableName("is_marketing_thirdparty_devices")
public class MarketingThirdpartyDevices implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 部门id
     */
    private Long depId;

    /**
     * 企业id
     */
    private Long groupId;

    /**
     * 设备序列号
     */
    private Integer deviceId;

    /**
     * 设备mac
     */
    private String deviceMac;

    private String deviceName;

    /**
     * 设备系统类型(1:安卓;2:IOS)
     */
    private String deviceType;

    /**
     * 设备状态(1:未绑定；2：已绑定(服务中)；3：已解绑；4：已禁用 ; 5: 已过期)
     */
    private String deviceStatus;

    /**
     * 在线状态(1:在线；2：离线)
     */
    private String onlineStatus;

    /**
     * 设备版本号
     */
    private String deviceVersion;

    /**
     * 是否是最新版本(1:是；2：否)
     */
    private Integer isLatestVersion;

    /**
     * 设备注册时间
     */
    private LocalDateTime registerTime;

    /**
     * 设备绑定时间(设备注册时同步新增，设备解绑后2次绑定后更新)
     */
    private LocalDateTime bindingTime;

    /**
     * 解绑时间
     */
    private LocalDateTime relieveTime;

    /**
     * 禁用时间
     */
    private LocalDateTime disabledTime;

    /**
     * 过期时间
     */
    private LocalDateTime expiredTime;

    /**
     * 最后一次在线时间(超过6分钟没收到心跳改为离线)
     */
    private LocalDateTime latestOnlineTime;

    private LocalDateTime latestOfflineTime;

    /**
     * 设备注册时门店id
     */
    private Long registerDepId;

    /**
     * 默认启动功能id
     */
    private Long defaultStartupFunctionId;

    /**
     * 对焦距离
     */
    private Integer focusDistance;

    /**
     * 最小人脸  80-200 
     */
    private Integer minFaceSize;

    /**
     * 自动对焦
     */
    private Boolean autoFocus;

    /**
     * 焦距距离 0 - 3.3
     */
    private Integer focusLen;

    /**
     *  清晰度 0 - 1.0
     */
    private Integer blur;

    /**
     * 角度 0 - 45
     */
    private Integer angel;

    /**
     * 裁剪的比例 识别的范围 0 - 1
     */
    private Integer cropPercent;

    /**
     * 门禁相似度
     */
    private BigDecimal entranceGuardThreshold;

    /**
     * 横竖屏（1：横屏；2：竖屏）
     */
    private Integer horizontalVerticalScreen;

    /**
     * 前后摄像头（1：前置：2：后置）
     */
    private Integer frontBehindCamera;

    /**
     * 摄像头型号(1:罗技；2：FR2, 3:FR3)
     */
    private String cameraModel;

    /**
     * 旋转角度
     */
    private Integer angleOfRotation;

    /**
     * 主FR3设备mac（后期只在此配置，无需在门禁或验证配置表配置）
     */
    private String frDevice;

    /**
     * 设备类型（1：一体机；2：盒子）
     */
    private String deviceUse;

    /**
     * 新旧版本标识(0:旧：1：新)
     */
    private String versionTag;


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getDepId() {
        return depId;
    }

    public void setDepId(Long depId) {
        this.depId = depId;
    }

    public Long getGroupId() {
        return groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public Integer getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(Integer deviceId) {
        this.deviceId = deviceId;
    }

    public String getDeviceMac() {
        return deviceMac;
    }

    public void setDeviceMac(String deviceMac) {
        this.deviceMac = deviceMac;
    }

    public String getDeviceName() {
        return deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public String getDeviceType() {
        return deviceType;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public String getDeviceStatus() {
        return deviceStatus;
    }

    public void setDeviceStatus(String deviceStatus) {
        this.deviceStatus = deviceStatus;
    }

    public String getOnlineStatus() {
        return onlineStatus;
    }

    public void setOnlineStatus(String onlineStatus) {
        this.onlineStatus = onlineStatus;
    }

    public String getDeviceVersion() {
        return deviceVersion;
    }

    public void setDeviceVersion(String deviceVersion) {
        this.deviceVersion = deviceVersion;
    }

    public Integer getIsLatestVersion() {
        return isLatestVersion;
    }

    public void setIsLatestVersion(Integer isLatestVersion) {
        this.isLatestVersion = isLatestVersion;
    }

    public LocalDateTime getRegisterTime() {
        return registerTime;
    }

    public void setRegisterTime(LocalDateTime registerTime) {
        this.registerTime = registerTime;
    }

    public LocalDateTime getBindingTime() {
        return bindingTime;
    }

    public void setBindingTime(LocalDateTime bindingTime) {
        this.bindingTime = bindingTime;
    }

    public LocalDateTime getRelieveTime() {
        return relieveTime;
    }

    public void setRelieveTime(LocalDateTime relieveTime) {
        this.relieveTime = relieveTime;
    }

    public LocalDateTime getDisabledTime() {
        return disabledTime;
    }

    public void setDisabledTime(LocalDateTime disabledTime) {
        this.disabledTime = disabledTime;
    }

    public LocalDateTime getExpiredTime() {
        return expiredTime;
    }

    public void setExpiredTime(LocalDateTime expiredTime) {
        this.expiredTime = expiredTime;
    }

    public LocalDateTime getLatestOnlineTime() {
        return latestOnlineTime;
    }

    public void setLatestOnlineTime(LocalDateTime latestOnlineTime) {
        this.latestOnlineTime = latestOnlineTime;
    }

    public LocalDateTime getLatestOfflineTime() {
        return latestOfflineTime;
    }

    public void setLatestOfflineTime(LocalDateTime latestOfflineTime) {
        this.latestOfflineTime = latestOfflineTime;
    }

    public Long getRegisterDepId() {
        return registerDepId;
    }

    public void setRegisterDepId(Long registerDepId) {
        this.registerDepId = registerDepId;
    }

    public Long getDefaultStartupFunctionId() {
        return defaultStartupFunctionId;
    }

    public void setDefaultStartupFunctionId(Long defaultStartupFunctionId) {
        this.defaultStartupFunctionId = defaultStartupFunctionId;
    }

    public Integer getFocusDistance() {
        return focusDistance;
    }

    public void setFocusDistance(Integer focusDistance) {
        this.focusDistance = focusDistance;
    }

    public Integer getMinFaceSize() {
        return minFaceSize;
    }

    public void setMinFaceSize(Integer minFaceSize) {
        this.minFaceSize = minFaceSize;
    }

    public Boolean getAutoFocus() {
        return autoFocus;
    }

    public void setAutoFocus(Boolean autoFocus) {
        this.autoFocus = autoFocus;
    }

    public Integer getFocusLen() {
        return focusLen;
    }

    public void setFocusLen(Integer focusLen) {
        this.focusLen = focusLen;
    }

    public Integer getBlur() {
        return blur;
    }

    public void setBlur(Integer blur) {
        this.blur = blur;
    }

    public Integer getAngel() {
        return angel;
    }

    public void setAngel(Integer angel) {
        this.angel = angel;
    }

    public Integer getCropPercent() {
        return cropPercent;
    }

    public void setCropPercent(Integer cropPercent) {
        this.cropPercent = cropPercent;
    }

    public BigDecimal getEntranceGuardThreshold() {
        return entranceGuardThreshold;
    }

    public void setEntranceGuardThreshold(BigDecimal entranceGuardThreshold) {
        this.entranceGuardThreshold = entranceGuardThreshold;
    }

    public Integer getHorizontalVerticalScreen() {
        return horizontalVerticalScreen;
    }

    public void setHorizontalVerticalScreen(Integer horizontalVerticalScreen) {
        this.horizontalVerticalScreen = horizontalVerticalScreen;
    }

    public Integer getFrontBehindCamera() {
        return frontBehindCamera;
    }

    public void setFrontBehindCamera(Integer frontBehindCamera) {
        this.frontBehindCamera = frontBehindCamera;
    }

    public String getCameraModel() {
        return cameraModel;
    }

    public void setCameraModel(String cameraModel) {
        this.cameraModel = cameraModel;
    }

    public Integer getAngleOfRotation() {
        return angleOfRotation;
    }

    public void setAngleOfRotation(Integer angleOfRotation) {
        this.angleOfRotation = angleOfRotation;
    }

    public String getFrDevice() {
        return frDevice;
    }

    public void setFrDevice(String frDevice) {
        this.frDevice = frDevice;
    }

    public String getDeviceUse() {
        return deviceUse;
    }

    public void setDeviceUse(String deviceUse) {
        this.deviceUse = deviceUse;
    }

    public String getVersionTag() {
        return versionTag;
    }

    public void setVersionTag(String versionTag) {
        this.versionTag = versionTag;
    }

    @Override
    public String toString() {
        return "MarketingThirdpartyDevices{" +
        "id=" + id +
        ", depId=" + depId +
        ", groupId=" + groupId +
        ", deviceId=" + deviceId +
        ", deviceMac=" + deviceMac +
        ", deviceName=" + deviceName +
        ", deviceType=" + deviceType +
        ", deviceStatus=" + deviceStatus +
        ", onlineStatus=" + onlineStatus +
        ", deviceVersion=" + deviceVersion +
        ", isLatestVersion=" + isLatestVersion +
        ", registerTime=" + registerTime +
        ", bindingTime=" + bindingTime +
        ", relieveTime=" + relieveTime +
        ", disabledTime=" + disabledTime +
        ", expiredTime=" + expiredTime +
        ", latestOnlineTime=" + latestOnlineTime +
        ", latestOfflineTime=" + latestOfflineTime +
        ", registerDepId=" + registerDepId +
        ", defaultStartupFunctionId=" + defaultStartupFunctionId +
        ", focusDistance=" + focusDistance +
        ", minFaceSize=" + minFaceSize +
        ", autoFocus=" + autoFocus +
        ", focusLen=" + focusLen +
        ", blur=" + blur +
        ", angel=" + angel +
        ", cropPercent=" + cropPercent +
        ", entranceGuardThreshold=" + entranceGuardThreshold +
        ", horizontalVerticalScreen=" + horizontalVerticalScreen +
        ", frontBehindCamera=" + frontBehindCamera +
        ", cameraModel=" + cameraModel +
        ", angleOfRotation=" + angleOfRotation +
        ", frDevice=" + frDevice +
        ", deviceUse=" + deviceUse +
        ", versionTag=" + versionTag +
        "}";
    }
}
