package com.ovopark.boot.business.analysis.shopweb.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.ovopark.boot.business.analysis.shopweb.entity.Departments;
import com.ovopark.boot.business.analysis.shopweb.entity.dto.TotalDeptsDto;

import java.util.List;

/**
 * Created by xuxing on 2019/6/17
 */
public interface DepartmentsService extends IService<Departments> {

  /**
   * 按照年、月、日统计门店新增数量
   *
   * @param type      按照年、月、日类型查询新增的数量
   *                  示例：1、年；2、月；3：日
   * @param starttime 查询指定范围的起始时间
   * @param endtime   查询指定范围的结束时间
   * @return 对应日期格式新增数量集合
   */
  List<TotalDeptsDto> getDeptsNumGroupByType(String type, String starttime, String endtime);
}
