package com.ovopark.boot.business.base.code;

import com.ovopark.boot.core.code.AbstractReturnCode;

/**
 * 
 * @ClassName: BaseReturnCode
 * @Description:TODO(Base系统编码,base系统编号为S206，即返回码区间为206000~206999)
 * 开放平台返回码206001~206099
 * 业务平台返回码206101~206999
 * @author: Remiel_Mercy
 * @date: 2019年3月4日 下午5:03:32
 * 
 * @Copyright: 2019 www.ovopark.com Inc. All rights reserved.
 */
public class BaseReturnCode extends AbstractReturnCode {
	public BaseReturnCode(String desc, String name, int code) {
		super(desc, name, code);
	}

	private static final long serialVersionUID = 1L;
	//开放平台用户不存在
	public static final int OPEN_USER_IS_NULL_CODE = 206001;
	public final static AbstractReturnCode OPEN_USER_IS_NULL = new BaseReturnCode("开放平台用户不存在", "OPEN_USER_IS_NULL",
			OPEN_USER_IS_NULL_CODE);

	//用户不存在
	public static final int OVOPARK_USER_IS_NULL_CODE = 206101;
	public final static AbstractReturnCode OVOPARK_USER_IS_NULL = new BaseReturnCode("业务平台用户不存在", "OVOPARK_USER_IS_NULL",
			OVOPARK_USER_IS_NULL_CODE);
	
	//业务平台未做绑定
	public static final int BUSINESS_PLATFORM_UNBOUND_CODE=206003;	
	public final static AbstractReturnCode BUSINESS_PLATFORM_UNBOUND = new BaseReturnCode("业务平台未做绑定,请联系客服","BUSINESS_PLATFORM_UNBOUND", BUSINESS_PLATFORM_UNBOUND_CODE);

	//门店不存在
	public static final int DEPARTMENT_NOT_EXIST_CODE=206004;	
	public final static AbstractReturnCode DEPARTMENT_NOT_EXIST = new BaseReturnCode("部门不存在","DEPARTMENT_NOT_EXIST", DEPARTMENT_NOT_EXIST_CODE);
	
	//组织架构不匹配
	public static final int ORGANIZATIONAL_MISMATCH_CODE=206005;	
	public final static AbstractReturnCode ORGANIZATIONAL_MISMATCH = new BaseReturnCode("组织架构不匹配","ORGANIZATIONAL_MISMATCH", ORGANIZATIONAL_MISMATCH_CODE);
	
	//代理商没有此企业权限
	public static final int AGENT_PERMISSION_DENIED_CODE=206006;	
	public final static AbstractReturnCode AGENT_PERMISSION_DENIED = new BaseReturnCode("代理商没有此企业权限","AGENT_PERMISSION_DENIED", AGENT_PERMISSION_DENIED_CODE);
	
	
	//代理商需要指定企业
	public static final int NEED_TO_DESIGNATE_ENTERPRISE_CODE=206007;	
	public final static AbstractReturnCode NEED_TO_DESIGNATE_ENTERPRISE = new BaseReturnCode("代理商需要指定企业","NEED_TO_DESIGNATE_ENTERPRISE", NEED_TO_DESIGNATE_ENTERPRISE_CODE);
	
	public static final int SUPPLIER_ACCOUNT_NOT_CONFIGURED_CODE=206008;	
	public final static AbstractReturnCode SUPPLIER_ACCOUNT_NOT_CONFIGURED = new BaseReturnCode("供应商帐号未配置","SUPPLIER_ACCOUNT_NOT_CONFIGURED", SUPPLIER_ACCOUNT_NOT_CONFIGURED_CODE);
	
	public static final int SUPPLIER_ACCOUNT_NON_EXISTENT_CODE=206009;	
	public final static AbstractReturnCode SUPPLIER_ACCOUNT_NON_EXISTENT = new BaseReturnCode("供应商帐号不存在","SUPPLIER_ACCOUNT_NON_EXISTENT", SUPPLIER_ACCOUNT_NON_EXISTENT_CODE);
	
	
	
	//business-base服务调用异常
	public static final int BUSINESS_BASE_ERROR_CODE = 206999;
	public final static AbstractReturnCode BUSINESS_BASE_ERROR = new BaseReturnCode("business-base服务调用异常", "BUSINESS_BASE_ERROR",
			BUSINESS_BASE_ERROR_CODE);
	

}
